<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Indicators Structs
 * Meta informations extracted from the WSDL
 * - documentation: This element restricts fares which can be returned in response. If a customer passes this element, all its children should be specified.
 * @subpackage Structs
 */
class Indicators extends AbstractStructBase
{
    /**
     * The RetainFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\RetainFare
     */
    public $RetainFare;
    /**
     * The MinMaxStay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\MinMaxStay
     */
    public $MinMaxStay;
    /**
     * The RefundPenalty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\RefundPenalty
     */
    public $RefundPenalty;
    /**
     * The ResTicketing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ResTicketing
     */
    public $ResTicketing;
    /**
     * The TravelPolicy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TravelPolicy
     */
    public $TravelPolicy;
    /**
     * Constructor method for Indicators
     * @uses Indicators::setRetainFare()
     * @uses Indicators::setMinMaxStay()
     * @uses Indicators::setRefundPenalty()
     * @uses Indicators::setResTicketing()
     * @uses Indicators::setTravelPolicy()
     * @param \Sabre\BargainFinderMax\Structs\RetainFare $retainFare
     * @param \Sabre\BargainFinderMax\Structs\MinMaxStay $minMaxStay
     * @param \Sabre\BargainFinderMax\Structs\RefundPenalty $refundPenalty
     * @param \Sabre\BargainFinderMax\Structs\ResTicketing $resTicketing
     * @param \Sabre\BargainFinderMax\Structs\TravelPolicy $travelPolicy
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\RetainFare $retainFare = null, \Sabre\BargainFinderMax\Structs\MinMaxStay $minMaxStay = null, \Sabre\BargainFinderMax\Structs\RefundPenalty $refundPenalty = null, \Sabre\BargainFinderMax\Structs\ResTicketing $resTicketing = null, \Sabre\BargainFinderMax\Structs\TravelPolicy $travelPolicy = null)
    {
        $this
            ->setRetainFare($retainFare)
            ->setMinMaxStay($minMaxStay)
            ->setRefundPenalty($refundPenalty)
            ->setResTicketing($resTicketing)
            ->setTravelPolicy($travelPolicy);
    }
    /**
     * Get RetainFare value
     * @return \Sabre\BargainFinderMax\Structs\RetainFare|null
     */
    public function getRetainFare()
    {
        return $this->RetainFare;
    }
    /**
     * Set RetainFare value
     * @param \Sabre\BargainFinderMax\Structs\RetainFare $retainFare
     * @return \Sabre\BargainFinderMax\Structs\Indicators
     */
    public function setRetainFare(\Sabre\BargainFinderMax\Structs\RetainFare $retainFare = null)
    {
        $this->RetainFare = $retainFare;
        return $this;
    }
    /**
     * Get MinMaxStay value
     * @return \Sabre\BargainFinderMax\Structs\MinMaxStay|null
     */
    public function getMinMaxStay()
    {
        return $this->MinMaxStay;
    }
    /**
     * Set MinMaxStay value
     * @param \Sabre\BargainFinderMax\Structs\MinMaxStay $minMaxStay
     * @return \Sabre\BargainFinderMax\Structs\Indicators
     */
    public function setMinMaxStay(\Sabre\BargainFinderMax\Structs\MinMaxStay $minMaxStay = null)
    {
        $this->MinMaxStay = $minMaxStay;
        return $this;
    }
    /**
     * Get RefundPenalty value
     * @return \Sabre\BargainFinderMax\Structs\RefundPenalty|null
     */
    public function getRefundPenalty()
    {
        return $this->RefundPenalty;
    }
    /**
     * Set RefundPenalty value
     * @param \Sabre\BargainFinderMax\Structs\RefundPenalty $refundPenalty
     * @return \Sabre\BargainFinderMax\Structs\Indicators
     */
    public function setRefundPenalty(\Sabre\BargainFinderMax\Structs\RefundPenalty $refundPenalty = null)
    {
        $this->RefundPenalty = $refundPenalty;
        return $this;
    }
    /**
     * Get ResTicketing value
     * @return \Sabre\BargainFinderMax\Structs\ResTicketing|null
     */
    public function getResTicketing()
    {
        return $this->ResTicketing;
    }
    /**
     * Set ResTicketing value
     * @param \Sabre\BargainFinderMax\Structs\ResTicketing $resTicketing
     * @return \Sabre\BargainFinderMax\Structs\Indicators
     */
    public function setResTicketing(\Sabre\BargainFinderMax\Structs\ResTicketing $resTicketing = null)
    {
        $this->ResTicketing = $resTicketing;
        return $this;
    }
    /**
     * Get TravelPolicy value
     * @return \Sabre\BargainFinderMax\Structs\TravelPolicy|null
     */
    public function getTravelPolicy()
    {
        return $this->TravelPolicy;
    }
    /**
     * Set TravelPolicy value
     * @param \Sabre\BargainFinderMax\Structs\TravelPolicy $travelPolicy
     * @return \Sabre\BargainFinderMax\Structs\Indicators
     */
    public function setTravelPolicy(\Sabre\BargainFinderMax\Structs\TravelPolicy $travelPolicy = null)
    {
        $this->TravelPolicy = $travelPolicy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Indicators
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
