<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IETCountryWOBSP Structs
 * @subpackage Structs
 */
class IETCountryWOBSP extends AbstractStructBase
{
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Country[]
     */
    public $Country;
    /**
     * Constructor method for IETCountryWOBSP
     * @uses IETCountryWOBSP::setCountry()
     * @param \Sabre\BargainFinderMax\Structs\Country[] $country
     */
    public function __construct(array $country = array())
    {
        $this
            ->setCountry($country);
    }
    /**
     * Get Country value
     * @return \Sabre\BargainFinderMax\Structs\Country[]|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Country[] $country
     * @return \Sabre\BargainFinderMax\Structs\IETCountryWOBSP
     */
    public function setCountry(array $country = array())
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Add item to Country value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Country $item
     * @return \Sabre\BargainFinderMax\Structs\IETCountryWOBSP
     */
    public function addToCountry(\Sabre\BargainFinderMax\Structs\Country $item)
    {
        $this->Country[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\IETCountryWOBSP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
