<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HiddenStopType Structs
 * @subpackage Structs
 */
class HiddenStopType extends AbstractStructBase
{
    /**
     * The Airport
     * Meta informations extracted from the WSDL
     * - documentation: Intermediate point airport code | Airport code type
     * - use: required | optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * @var string
     */
    public $Airport;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - documentation: Intermediate point city code | City code type
     * - use: optional
     * - length: 3
     * - pattern: [A-Z]{3}
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - documentation: Intermediate point state code | State code type | The postal service standard code or abbreviation for the state, province, or region. | Used for Character Strings, length 1 to 8
     * - use: optional
     * - length: 2
     * - minLength: 2 | 1
     * - pattern: [A-Z]{2}
     * - maxLength: 8
     * @var string
     */
    public $State;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - documentation: Intermediate point country code | Country code type
     * - use: optional
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $Country;
    /**
     * The ArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: Arrival time at intermediate point
     * - use: optional
     * @var string
     */
    public $ArrivalTime;
    /**
     * The ArrivalDateAdjustment
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Arrival Date Adjustment(this is the difference in days between flight arrival date at intermediate point and departure date)
     * - use: optional
     * @var int
     */
    public $ArrivalDateAdjustment;
    /**
     * The DepartureTime
     * Meta informations extracted from the WSDL
     * - documentation: Departure time at intermediate point
     * - use: optional
     * @var string
     */
    public $DepartureTime;
    /**
     * The DepartureDateAdjustment
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Departure Date Adjustment(this is the difference in days between flight departure date from intermediate point and departure date)
     * - use: optional
     * @var int
     */
    public $DepartureDateAdjustment;
    /**
     * The AirMiles
     * Meta informations extracted from the WSDL
     * - documentation: Air miles flight leg
     * - use: optional
     * @var int
     */
    public $AirMiles;
    /**
     * The ElapsedTime
     * Meta informations extracted from the WSDL
     * - documentation: Elapsed time flight leg in minutes
     * - use: optional
     * @var int
     */
    public $ElapsedTime;
    /**
     * The ElapsedLayoverTime
     * Meta informations extracted from the WSDL
     * - documentation: Elapsed layover time in minutes
     * - use: optional
     * @var int
     */
    public $ElapsedLayoverTime;
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - documentation: Equipment type for intermediate point | Air Equipment type
     * - use: optional
     * - pattern: [0-9A-Z]{1,4}
     * @var string
     */
    public $Equipment;
    /**
     * Constructor method for HiddenStopType
     * @uses HiddenStopType::setAirport()
     * @uses HiddenStopType::setCity()
     * @uses HiddenStopType::setState()
     * @uses HiddenStopType::setCountry()
     * @uses HiddenStopType::setArrivalTime()
     * @uses HiddenStopType::setArrivalDateAdjustment()
     * @uses HiddenStopType::setDepartureTime()
     * @uses HiddenStopType::setDepartureDateAdjustment()
     * @uses HiddenStopType::setAirMiles()
     * @uses HiddenStopType::setElapsedTime()
     * @uses HiddenStopType::setElapsedLayoverTime()
     * @uses HiddenStopType::setEquipment()
     * @param string $airport
     * @param string $city
     * @param string $state
     * @param string $country
     * @param string $arrivalTime
     * @param int $arrivalDateAdjustment
     * @param string $departureTime
     * @param int $departureDateAdjustment
     * @param int $airMiles
     * @param int $elapsedTime
     * @param int $elapsedLayoverTime
     * @param string $equipment
     */
    public function __construct($airport = null, $city = null, $state = null, $country = null, $arrivalTime = null, $arrivalDateAdjustment = 0, $departureTime = null, $departureDateAdjustment = 0, $airMiles = null, $elapsedTime = null, $elapsedLayoverTime = null, $equipment = null)
    {
        $this
            ->setAirport($airport)
            ->setCity($city)
            ->setState($state)
            ->setCountry($country)
            ->setArrivalTime($arrivalTime)
            ->setArrivalDateAdjustment($arrivalDateAdjustment)
            ->setDepartureTime($departureTime)
            ->setDepartureDateAdjustment($departureDateAdjustment)
            ->setAirMiles($airMiles)
            ->setElapsedTime($elapsedTime)
            ->setElapsedLayoverTime($elapsedLayoverTime)
            ->setEquipment($equipment);
    }
    /**
     * Get Airport value
     * @return string|null
     */
    public function getAirport()
    {
        return $this->Airport;
    }
    /**
     * Set Airport value
     * @param string $airport
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setAirport($airport = null)
    {
        $this->Airport = $airport;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setCity($city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setState($state = null)
    {
        $this->State = $state;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setCountry($country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get ArrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setArrivalTime($arrivalTime = null)
    {
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get ArrivalDateAdjustment value
     * @return int|null
     */
    public function getArrivalDateAdjustment()
    {
        return $this->ArrivalDateAdjustment;
    }
    /**
     * Set ArrivalDateAdjustment value
     * @param int $arrivalDateAdjustment
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setArrivalDateAdjustment($arrivalDateAdjustment = 0)
    {
        $this->ArrivalDateAdjustment = $arrivalDateAdjustment;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setDepartureTime($departureTime = null)
    {
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get DepartureDateAdjustment value
     * @return int|null
     */
    public function getDepartureDateAdjustment()
    {
        return $this->DepartureDateAdjustment;
    }
    /**
     * Set DepartureDateAdjustment value
     * @param int $departureDateAdjustment
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setDepartureDateAdjustment($departureDateAdjustment = 0)
    {
        $this->DepartureDateAdjustment = $departureDateAdjustment;
        return $this;
    }
    /**
     * Get AirMiles value
     * @return int|null
     */
    public function getAirMiles()
    {
        return $this->AirMiles;
    }
    /**
     * Set AirMiles value
     * @param int $airMiles
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setAirMiles($airMiles = null)
    {
        $this->AirMiles = $airMiles;
        return $this;
    }
    /**
     * Get ElapsedTime value
     * @return int|null
     */
    public function getElapsedTime()
    {
        return $this->ElapsedTime;
    }
    /**
     * Set ElapsedTime value
     * @param int $elapsedTime
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setElapsedTime($elapsedTime = null)
    {
        $this->ElapsedTime = $elapsedTime;
        return $this;
    }
    /**
     * Get ElapsedLayoverTime value
     * @return int|null
     */
    public function getElapsedLayoverTime()
    {
        return $this->ElapsedLayoverTime;
    }
    /**
     * Set ElapsedLayoverTime value
     * @param int $elapsedLayoverTime
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setElapsedLayoverTime($elapsedLayoverTime = null)
    {
        $this->ElapsedLayoverTime = $elapsedLayoverTime;
        return $this;
    }
    /**
     * Get Equipment value
     * @return string|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param string $equipment
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public function setEquipment($equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\HiddenStopType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
