<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HandlingMarkupSummaryType Structs
 * @subpackage Structs
 */
class HandlingMarkupSummaryType extends AbstractStructBase
{
    /**
     * The TypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Value M: Embedded Mark Up, J: Adjusted Selling, H: Handling Fee, G: GST Taxes | Used for Characters, length 1 | Used for Characters, length 1
     * - use: required
     * - length: 1
     * @var string
     */
    public $TypeCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Max 10 chars
     * - use: required
     * @var string
     */
    public $Description;
    /**
     * The MonetaryAmountValue
     * Meta informations extracted from the WSDL
     * - documentation: Can be negative. This is in equivalent amount currency. | Used for amounts, max 3 decimals
     * - use: required
     * - fractionDigits: 3
     * @var float
     */
    public $MonetaryAmountValue;
    /**
     * Constructor method for HandlingMarkupSummaryType
     * @uses HandlingMarkupSummaryType::setTypeCode()
     * @uses HandlingMarkupSummaryType::setDescription()
     * @uses HandlingMarkupSummaryType::setMonetaryAmountValue()
     * @param string $typeCode
     * @param string $description
     * @param float $monetaryAmountValue
     */
    public function __construct($typeCode = null, $description = null, $monetaryAmountValue = null)
    {
        $this
            ->setTypeCode($typeCode)
            ->setDescription($description)
            ->setMonetaryAmountValue($monetaryAmountValue);
    }
    /**
     * Get TypeCode value
     * @return string
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupSummaryType
     */
    public function setTypeCode($typeCode = null)
    {
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupSummaryType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get MonetaryAmountValue value
     * @return float
     */
    public function getMonetaryAmountValue()
    {
        return $this->MonetaryAmountValue;
    }
    /**
     * Set MonetaryAmountValue value
     * @param float $monetaryAmountValue
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupSummaryType
     */
    public function setMonetaryAmountValue($monetaryAmountValue = null)
    {
        $this->MonetaryAmountValue = $monetaryAmountValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\HandlingMarkupSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
