<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegment Structs
 * Meta informations extracted from the WSDL
 * - documentation: A container for necessary data to describe one or more flight segments.
 * @subpackage Structs
 */
class FlightSegment extends AbstractStructBase
{
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - documentation: Departure point of flight segment.
     * @var \Sabre\BargainFinderMax\Structs\ResponseLocationType
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - documentation: Arrival point of flight segment.
     * @var \Sabre\BargainFinderMax\Structs\ResponseLocationType
     */
    public $ArrivalAirport;
    /**
     * The DepartureAirportCode
     * @var string
     */
    public $DepartureAirportCode;
    /**
     * The ArrivalAirportCode
     * @var string
     */
    public $ArrivalAirportCode;
    /**
     * Constructor method for FlightSegment
     * @uses FlightSegment::setDepartureDateTime()
     * @uses FlightSegment::setDepartureAirport()
     * @uses FlightSegment::setArrivalAirport()
     * @uses FlightSegment::setDepartureAirportCode()
     * @uses FlightSegment::setArrivalAirportCode()
     * @param string $departureDateTime
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $departureAirport
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $arrivalAirport
     * @param string $departureAirportCode
     * @param string $arrivalAirportCode
     */
    public function __construct($departureDateTime = null, \Sabre\BargainFinderMax\Structs\ResponseLocationType $departureAirport = null, \Sabre\BargainFinderMax\Structs\ResponseLocationType $arrivalAirport = null, $departureAirportCode = null, $arrivalAirportCode = null)
    {
        $this
            ->setDepartureDateTime($departureDateTime)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setDepartureAirportCode($departureAirportCode)
            ->setArrivalAirportCode($arrivalAirportCode);
    }
    /**
     * Get DepartureDateTime value
     * @return string
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\BargainFinderMax\Structs\FlightSegment
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \Sabre\BargainFinderMax\Structs\ResponseLocationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $departureAirport
     * @return \Sabre\BargainFinderMax\Structs\FlightSegment
     */
    public function setDepartureAirport(\Sabre\BargainFinderMax\Structs\ResponseLocationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \Sabre\BargainFinderMax\Structs\ResponseLocationType|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $arrivalAirport
     * @return \Sabre\BargainFinderMax\Structs\FlightSegment
     */
    public function setArrivalAirport(\Sabre\BargainFinderMax\Structs\ResponseLocationType $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get DepartureAirportCode value
     * @return string|null
     */
    public function getDepartureAirportCode()
    {
        return $this->DepartureAirportCode;
    }
    /**
     * Set DepartureAirportCode value
     * @param string $departureAirportCode
     * @return \Sabre\BargainFinderMax\Structs\FlightSegment
     */
    public function setDepartureAirportCode($departureAirportCode = null)
    {
        $this->DepartureAirportCode = $departureAirportCode;
        return $this;
    }
    /**
     * Get ArrivalAirportCode value
     * @return string|null
     */
    public function getArrivalAirportCode()
    {
        return $this->ArrivalAirportCode;
    }
    /**
     * Set ArrivalAirportCode value
     * @param string $arrivalAirportCode
     * @return \Sabre\BargainFinderMax\Structs\FlightSegment
     */
    public function setArrivalAirportCode($arrivalAirportCode = null)
    {
        $this->ArrivalAirportCode = $arrivalAirportCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FlightSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
