<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Holds a base fare, tax, total and currency information on a price
 * @subpackage Structs
 */
class FareType extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * - pattern: [0-9A-Z]{1,3}
     * @var string
     */
    public $Code;
    /**
     * The BaseFare
     * Meta informations extracted from the WSDL
     * - documentation: Price of the inventory excluding taxes and fees.
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $BaseFare;
    /**
     * The NonRefundableBaseFare
     * Meta informations extracted from the WSDL
     * - documentation: Non-refundable base fare amount
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $NonRefundableBaseFare;
    /**
     * The FareConstruction
     * Meta informations extracted from the WSDL
     * - documentation: Fare construction total amount.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $FareConstruction;
    /**
     * The EquivFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\EquivFare
     */
    public $EquivFare;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Taxes
     */
    public $Taxes;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Fees
     */
    public $Fees;
    /**
     * The OBFees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OBFees
     */
    public $OBFees;
    /**
     * The RateOfExchange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\RateOfExchangeType
     */
    public $RateOfExchange;
    /**
     * The CurrencyConversions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CurrencyConversionsType
     */
    public $CurrencyConversions;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - documentation: Itinerary total fare | The total price that the passenger would pay (includes fare, taxes, fees)
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $TotalFare;
    /**
     * The ReissueInfoList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ReissueInfoList
     */
    public $ReissueInfoList;
    /**
     * The PenaltiesInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PenaltiesInfo
     */
    public $PenaltiesInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The NegotiatedFare
     * Meta informations extracted from the WSDL
     * - documentation: Indicator to show if this is a private fare.
     * @var bool
     */
    public $NegotiatedFare;
    /**
     * The NegotiatedFareCode
     * Meta informations extracted from the WSDL
     * - documentation: Code used to identify the private fare.
     * @var string
     */
    public $NegotiatedFareCode;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The PassengerInfo
     * @var \Sabre\BargainFinderMax\Structs\PassengerInformationType
     */
    public $PassengerInfo;
    /**
     * The PassengerNotAvailableInfo
     * @var \Sabre\BargainFinderMax\Structs\PassengerNotAvailableInfoType
     */
    public $PassengerNotAvailableInfo;
    /**
     * The AncillaryFeeGroup
     * Meta informations extracted from the WSDL
     * - documentation: Ancillary service fee group list
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AncillaryFeeGroupType
     */
    public $AncillaryFeeGroup;
    /**
     * The ValidatingCarrier
     * Meta informations extracted from the WSDL
     * - documentation: Validating carrier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - use: optional
     * @var \Sabre\BargainFinderMax\Structs\ValidatingCarrierIDType[]
     */
    public $ValidatingCarrier;
    /**
     * The Reissue
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Reissue Indicator
     * - use: optional
     * @var bool
     */
    public $Reissue;
    /**
     * The ReissueText
     * Meta informations extracted from the WSDL
     * - documentation: Reissue Text
     * - use: optional
     * @var string
     */
    public $ReissueText;
    /**
     * The DivideByParty
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Divide party T/F indicates if different passenger types are booked in different inventories
     * - use: optional
     * @var bool
     */
    public $DivideByParty;
    /**
     * The SimultaneousReservation
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Simultaneous reservation flag indicates if the fare requires simultaneous reservations/ticketing
     * - use: optional
     * @var bool
     */
    public $SimultaneousReservation;
    /**
     * The VITA
     * Meta informations extracted from the WSDL
     * - default: X
     * - documentation: Validate Interline Ticketing Agreement - indicates whether the itin has VITA indicator or not.
     * - use: optional
     * @var string
     */
    public $VITA;
    /**
     * The ETicketable
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Is eTicketable.
     * - use: optional
     * @var bool
     */
    public $ETicketable;
    /**
     * The SpanishFamilyDiscount
     * @var string
     */
    public $SpanishFamilyDiscount;
    /**
     * The LastTicketDate
     * Meta informations extracted from the WSDL
     * - documentation: Last date to ticket
     * - use: optional
     * @var string
     */
    public $LastTicketDate;
    /**
     * The GoverningCarriers
     * Meta informations extracted from the WSDL
     * - documentation: List of Governing Carriers | Airline carrier code type
     * - use: optional
     * - pattern: \*\*
     * @var string
     */
    public $GoverningCarriers;
    /**
     * Constructor method for FareType
     * @uses FareType::setCode()
     * @uses FareType::setBaseFare()
     * @uses FareType::setNonRefundableBaseFare()
     * @uses FareType::setFareConstruction()
     * @uses FareType::setEquivFare()
     * @uses FareType::setTaxes()
     * @uses FareType::setFees()
     * @uses FareType::setOBFees()
     * @uses FareType::setRateOfExchange()
     * @uses FareType::setCurrencyConversions()
     * @uses FareType::setTotalFare()
     * @uses FareType::setReissueInfoList()
     * @uses FareType::setPenaltiesInfo()
     * @uses FareType::setTPA_Extensions()
     * @uses FareType::setNegotiatedFare()
     * @uses FareType::setNegotiatedFareCode()
     * @uses FareType::set_()
     * @uses FareType::setName()
     * @uses FareType::setPassengerInfo()
     * @uses FareType::setPassengerNotAvailableInfo()
     * @uses FareType::setAncillaryFeeGroup()
     * @uses FareType::setValidatingCarrier()
     * @uses FareType::setReissue()
     * @uses FareType::setReissueText()
     * @uses FareType::setDivideByParty()
     * @uses FareType::setSimultaneousReservation()
     * @uses FareType::setVITA()
     * @uses FareType::setETicketable()
     * @uses FareType::setSpanishFamilyDiscount()
     * @uses FareType::setLastTicketDate()
     * @uses FareType::setGoverningCarriers()
     * @param string $code
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $nonRefundableBaseFare
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $fareConstruction
     * @param \Sabre\BargainFinderMax\Structs\EquivFare $equivFare
     * @param \Sabre\BargainFinderMax\Structs\Taxes $taxes
     * @param \Sabre\BargainFinderMax\Structs\Fees $fees
     * @param \Sabre\BargainFinderMax\Structs\OBFees $oBFees
     * @param \Sabre\BargainFinderMax\Structs\RateOfExchangeType $rateOfExchange
     * @param \Sabre\BargainFinderMax\Structs\CurrencyConversionsType $currencyConversions
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare
     * @param \Sabre\BargainFinderMax\Structs\ReissueInfoList $reissueInfoList
     * @param \Sabre\BargainFinderMax\Structs\PenaltiesInfo $penaltiesInfo
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param bool $negotiatedFare
     * @param string $negotiatedFareCode
     * @param string $_
     * @param string $name
     * @param \Sabre\BargainFinderMax\Structs\PassengerInformationType $passengerInfo
     * @param \Sabre\BargainFinderMax\Structs\PassengerNotAvailableInfoType $passengerNotAvailableInfo
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeGroupType $ancillaryFeeGroup
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrierIDType[] $validatingCarrier
     * @param bool $reissue
     * @param string $reissueText
     * @param bool $divideByParty
     * @param bool $simultaneousReservation
     * @param string $vITA
     * @param bool $eTicketable
     * @param string $spanishFamilyDiscount
     * @param string $lastTicketDate
     * @param string $governingCarriers
     */
    public function __construct($code = null, \Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare = null, \Sabre\BargainFinderMax\Structs\CurrencyAmountType $nonRefundableBaseFare = null, \Sabre\BargainFinderMax\Structs\CurrencyAmountType $fareConstruction = null, \Sabre\BargainFinderMax\Structs\EquivFare $equivFare = null, \Sabre\BargainFinderMax\Structs\Taxes $taxes = null, \Sabre\BargainFinderMax\Structs\Fees $fees = null, \Sabre\BargainFinderMax\Structs\OBFees $oBFees = null, \Sabre\BargainFinderMax\Structs\RateOfExchangeType $rateOfExchange = null, \Sabre\BargainFinderMax\Structs\CurrencyConversionsType $currencyConversions = null, \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare = null, \Sabre\BargainFinderMax\Structs\ReissueInfoList $reissueInfoList = null, \Sabre\BargainFinderMax\Structs\PenaltiesInfo $penaltiesInfo = null, \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, $negotiatedFare = null, $negotiatedFareCode = null, $_ = null, $name = null, \Sabre\BargainFinderMax\Structs\PassengerInformationType $passengerInfo = null, \Sabre\BargainFinderMax\Structs\PassengerNotAvailableInfoType $passengerNotAvailableInfo = null, \Sabre\BargainFinderMax\Structs\AncillaryFeeGroupType $ancillaryFeeGroup = null, array $validatingCarrier = array(), $reissue = false, $reissueText = null, $divideByParty = false, $simultaneousReservation = false, $vITA = 'X', $eTicketable = false, $spanishFamilyDiscount = null, $lastTicketDate = null, $governingCarriers = null)
    {
        $this
            ->setCode($code)
            ->setBaseFare($baseFare)
            ->setNonRefundableBaseFare($nonRefundableBaseFare)
            ->setFareConstruction($fareConstruction)
            ->setEquivFare($equivFare)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setOBFees($oBFees)
            ->setRateOfExchange($rateOfExchange)
            ->setCurrencyConversions($currencyConversions)
            ->setTotalFare($totalFare)
            ->setReissueInfoList($reissueInfoList)
            ->setPenaltiesInfo($penaltiesInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setNegotiatedFare($negotiatedFare)
            ->setNegotiatedFareCode($negotiatedFareCode)
            ->set_($_)
            ->setName($name)
            ->setPassengerInfo($passengerInfo)
            ->setPassengerNotAvailableInfo($passengerNotAvailableInfo)
            ->setAncillaryFeeGroup($ancillaryFeeGroup)
            ->setValidatingCarrier($validatingCarrier)
            ->setReissue($reissue)
            ->setReissueText($reissueText)
            ->setDivideByParty($divideByParty)
            ->setSimultaneousReservation($simultaneousReservation)
            ->setVITA($vITA)
            ->setETicketable($eTicketable)
            ->setSpanishFamilyDiscount($spanishFamilyDiscount)
            ->setLastTicketDate($lastTicketDate)
            ->setGoverningCarriers($governingCarriers);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setBaseFare(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get NonRefundableBaseFare value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getNonRefundableBaseFare()
    {
        return $this->NonRefundableBaseFare;
    }
    /**
     * Set NonRefundableBaseFare value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $nonRefundableBaseFare
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setNonRefundableBaseFare(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $nonRefundableBaseFare = null)
    {
        $this->NonRefundableBaseFare = $nonRefundableBaseFare;
        return $this;
    }
    /**
     * Get FareConstruction value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getFareConstruction()
    {
        return $this->FareConstruction;
    }
    /**
     * Set FareConstruction value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $fareConstruction
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setFareConstruction(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $fareConstruction = null)
    {
        $this->FareConstruction = $fareConstruction;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \Sabre\BargainFinderMax\Structs\EquivFare|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * Set EquivFare value
     * @param \Sabre\BargainFinderMax\Structs\EquivFare $equivFare
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setEquivFare(\Sabre\BargainFinderMax\Structs\EquivFare $equivFare = null)
    {
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Sabre\BargainFinderMax\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\BargainFinderMax\Structs\Taxes $taxes
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setTaxes(\Sabre\BargainFinderMax\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return \Sabre\BargainFinderMax\Structs\Fees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \Sabre\BargainFinderMax\Structs\Fees $fees
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setFees(\Sabre\BargainFinderMax\Structs\Fees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get OBFees value
     * @return \Sabre\BargainFinderMax\Structs\OBFees|null
     */
    public function getOBFees()
    {
        return $this->OBFees;
    }
    /**
     * Set OBFees value
     * @param \Sabre\BargainFinderMax\Structs\OBFees $oBFees
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setOBFees(\Sabre\BargainFinderMax\Structs\OBFees $oBFees = null)
    {
        $this->OBFees = $oBFees;
        return $this;
    }
    /**
     * Get RateOfExchange value
     * @return \Sabre\BargainFinderMax\Structs\RateOfExchangeType|null
     */
    public function getRateOfExchange()
    {
        return $this->RateOfExchange;
    }
    /**
     * Set RateOfExchange value
     * @param \Sabre\BargainFinderMax\Structs\RateOfExchangeType $rateOfExchange
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setRateOfExchange(\Sabre\BargainFinderMax\Structs\RateOfExchangeType $rateOfExchange = null)
    {
        $this->RateOfExchange = $rateOfExchange;
        return $this;
    }
    /**
     * Get CurrencyConversions value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyConversionsType|null
     */
    public function getCurrencyConversions()
    {
        return $this->CurrencyConversions;
    }
    /**
     * Set CurrencyConversions value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyConversionsType $currencyConversions
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setCurrencyConversions(\Sabre\BargainFinderMax\Structs\CurrencyConversionsType $currencyConversions = null)
    {
        $this->CurrencyConversions = $currencyConversions;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setTotalFare(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get ReissueInfoList value
     * @return \Sabre\BargainFinderMax\Structs\ReissueInfoList|null
     */
    public function getReissueInfoList()
    {
        return $this->ReissueInfoList;
    }
    /**
     * Set ReissueInfoList value
     * @param \Sabre\BargainFinderMax\Structs\ReissueInfoList $reissueInfoList
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setReissueInfoList(\Sabre\BargainFinderMax\Structs\ReissueInfoList $reissueInfoList = null)
    {
        $this->ReissueInfoList = $reissueInfoList;
        return $this;
    }
    /**
     * Get PenaltiesInfo value
     * @return \Sabre\BargainFinderMax\Structs\PenaltiesInfo|null
     */
    public function getPenaltiesInfo()
    {
        return $this->PenaltiesInfo;
    }
    /**
     * Set PenaltiesInfo value
     * @param \Sabre\BargainFinderMax\Structs\PenaltiesInfo $penaltiesInfo
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setPenaltiesInfo(\Sabre\BargainFinderMax\Structs\PenaltiesInfo $penaltiesInfo = null)
    {
        $this->PenaltiesInfo = $penaltiesInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get NegotiatedFare value
     * @return bool|null
     */
    public function getNegotiatedFare()
    {
        return $this->NegotiatedFare;
    }
    /**
     * Set NegotiatedFare value
     * @param bool $negotiatedFare
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setNegotiatedFare($negotiatedFare = null)
    {
        $this->NegotiatedFare = $negotiatedFare;
        return $this;
    }
    /**
     * Get NegotiatedFareCode value
     * @return string|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * Set NegotiatedFareCode value
     * @param string $negotiatedFareCode
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setNegotiatedFareCode($negotiatedFareCode = null)
    {
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PassengerInfo value
     * @return \Sabre\BargainFinderMax\Structs\PassengerInformationType|null
     */
    public function getPassengerInfo()
    {
        return $this->PassengerInfo;
    }
    /**
     * Set PassengerInfo value
     * @param \Sabre\BargainFinderMax\Structs\PassengerInformationType $passengerInfo
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setPassengerInfo(\Sabre\BargainFinderMax\Structs\PassengerInformationType $passengerInfo = null)
    {
        $this->PassengerInfo = $passengerInfo;
        return $this;
    }
    /**
     * Get PassengerNotAvailableInfo value
     * @return \Sabre\BargainFinderMax\Structs\PassengerNotAvailableInfoType|null
     */
    public function getPassengerNotAvailableInfo()
    {
        return $this->PassengerNotAvailableInfo;
    }
    /**
     * Set PassengerNotAvailableInfo value
     * @param \Sabre\BargainFinderMax\Structs\PassengerNotAvailableInfoType $passengerNotAvailableInfo
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setPassengerNotAvailableInfo(\Sabre\BargainFinderMax\Structs\PassengerNotAvailableInfoType $passengerNotAvailableInfo = null)
    {
        $this->PassengerNotAvailableInfo = $passengerNotAvailableInfo;
        return $this;
    }
    /**
     * Get AncillaryFeeGroup value
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroupType|null
     */
    public function getAncillaryFeeGroup()
    {
        return $this->AncillaryFeeGroup;
    }
    /**
     * Set AncillaryFeeGroup value
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeGroupType $ancillaryFeeGroup
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setAncillaryFeeGroup(\Sabre\BargainFinderMax\Structs\AncillaryFeeGroupType $ancillaryFeeGroup = null)
    {
        $this->AncillaryFeeGroup = $ancillaryFeeGroup;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \Sabre\BargainFinderMax\Structs\ValidatingCarrierIDType[]|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrierIDType[] $validatingCarrier
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setValidatingCarrier(array $validatingCarrier = array())
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Add item to ValidatingCarrier value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ValidatingCarrierIDType $item
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function addToValidatingCarrier(\Sabre\BargainFinderMax\Structs\ValidatingCarrierIDType $item)
    {
        $this->ValidatingCarrier[] = $item;
        return $this;
    }
    /**
     * Get Reissue value
     * @return bool|null
     */
    public function getReissue()
    {
        return $this->Reissue;
    }
    /**
     * Set Reissue value
     * @param bool $reissue
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setReissue($reissue = false)
    {
        $this->Reissue = $reissue;
        return $this;
    }
    /**
     * Get ReissueText value
     * @return string|null
     */
    public function getReissueText()
    {
        return $this->ReissueText;
    }
    /**
     * Set ReissueText value
     * @param string $reissueText
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setReissueText($reissueText = null)
    {
        $this->ReissueText = $reissueText;
        return $this;
    }
    /**
     * Get DivideByParty value
     * @return bool|null
     */
    public function getDivideByParty()
    {
        return $this->DivideByParty;
    }
    /**
     * Set DivideByParty value
     * @param bool $divideByParty
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setDivideByParty($divideByParty = false)
    {
        $this->DivideByParty = $divideByParty;
        return $this;
    }
    /**
     * Get SimultaneousReservation value
     * @return bool|null
     */
    public function getSimultaneousReservation()
    {
        return $this->SimultaneousReservation;
    }
    /**
     * Set SimultaneousReservation value
     * @param bool $simultaneousReservation
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setSimultaneousReservation($simultaneousReservation = false)
    {
        $this->SimultaneousReservation = $simultaneousReservation;
        return $this;
    }
    /**
     * Get VITA value
     * @return string|null
     */
    public function getVITA()
    {
        return $this->VITA;
    }
    /**
     * Set VITA value
     * @param string $vITA
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setVITA($vITA = 'X')
    {
        $this->VITA = $vITA;
        return $this;
    }
    /**
     * Get ETicketable value
     * @return bool|null
     */
    public function getETicketable()
    {
        return $this->ETicketable;
    }
    /**
     * Set ETicketable value
     * @param bool $eTicketable
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setETicketable($eTicketable = false)
    {
        $this->ETicketable = $eTicketable;
        return $this;
    }
    /**
     * Get SpanishFamilyDiscount value
     * @return string|null
     */
    public function getSpanishFamilyDiscount()
    {
        return $this->SpanishFamilyDiscount;
    }
    /**
     * Set SpanishFamilyDiscount value
     * @param string $spanishFamilyDiscount
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setSpanishFamilyDiscount($spanishFamilyDiscount = null)
    {
        $this->SpanishFamilyDiscount = $spanishFamilyDiscount;
        return $this;
    }
    /**
     * Get LastTicketDate value
     * @return string|null
     */
    public function getLastTicketDate()
    {
        return $this->LastTicketDate;
    }
    /**
     * Set LastTicketDate value
     * @param string $lastTicketDate
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setLastTicketDate($lastTicketDate = null)
    {
        $this->LastTicketDate = $lastTicketDate;
        return $this;
    }
    /**
     * Get GoverningCarriers value
     * @return string|null
     */
    public function getGoverningCarriers()
    {
        return $this->GoverningCarriers;
    }
    /**
     * Set GoverningCarriers value
     * @param string $governingCarriers
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public function setGoverningCarriers($governingCarriers = null)
    {
        $this->GoverningCarriers = $governingCarriers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
