<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareParameters Structs
 * Meta informations extracted from the WSDL
 * - documentation: This element specifies parameters for desired fare.
 * @subpackage Structs
 */
class FareParameters extends AbstractStructBase
{
    /**
     * The ExcludeRestricted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ExcludeRestricted
     */
    public $ExcludeRestricted;
    /**
     * The ResTicketing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ResTicketing
     */
    public $ResTicketing;
    /**
     * The MinMaxStay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\MinMaxStay
     */
    public $MinMaxStay;
    /**
     * The RefundPenalty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\RefundPenalty
     */
    public $RefundPenalty;
    /**
     * The PublicFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PublicFare
     */
    public $PublicFare;
    /**
     * The PrivateFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PrivateFare
     */
    public $PrivateFare;
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Cabin
     */
    public $Cabin;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PassengerType
     */
    public $PassengerType;
    /**
     * The NegotiatedFaresOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\NegotiatedFaresOnly
     */
    public $NegotiatedFaresOnly;
    /**
     * The XOFares
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\XOFares
     */
    public $XOFares;
    /**
     * The UsePassengerFares
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\UsePassengerFares
     */
    public $UsePassengerFares;
    /**
     * The UseNegotiatedFares
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\UseNegotiatedFares
     */
    public $UseNegotiatedFares;
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - documentation: Define information on the number of passengers of a specific type.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType[]
     */
    public $PassengerTypeQuantity;
    /**
     * The JumpCabinLogic
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\JumpCabinLogicType
     */
    public $JumpCabinLogic;
    /**
     * The KeepSameCabin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\KeepSameCabinType
     */
    public $KeepSameCabin;
    /**
     * The VoluntaryChanges
     * Meta informations extracted from the WSDL
     * - documentation: Identifies whether penalties associated with voluntary changes should be included in the search results.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\VoluntaryChangesSMPType
     */
    public $VoluntaryChanges;
    /**
     * The CorporateID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CorporateID
     */
    public $CorporateID;
    /**
     * The AccountCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AccountCode
     */
    public $AccountCode;
    /**
     * Constructor method for FareParameters
     * @uses FareParameters::setExcludeRestricted()
     * @uses FareParameters::setResTicketing()
     * @uses FareParameters::setMinMaxStay()
     * @uses FareParameters::setRefundPenalty()
     * @uses FareParameters::setPublicFare()
     * @uses FareParameters::setPrivateFare()
     * @uses FareParameters::setCabin()
     * @uses FareParameters::setPassengerType()
     * @uses FareParameters::setNegotiatedFaresOnly()
     * @uses FareParameters::setXOFares()
     * @uses FareParameters::setUsePassengerFares()
     * @uses FareParameters::setUseNegotiatedFares()
     * @uses FareParameters::setPassengerTypeQuantity()
     * @uses FareParameters::setJumpCabinLogic()
     * @uses FareParameters::setKeepSameCabin()
     * @uses FareParameters::setVoluntaryChanges()
     * @uses FareParameters::setCorporateID()
     * @uses FareParameters::setAccountCode()
     * @param \Sabre\BargainFinderMax\Structs\ExcludeRestricted $excludeRestricted
     * @param \Sabre\BargainFinderMax\Structs\ResTicketing $resTicketing
     * @param \Sabre\BargainFinderMax\Structs\MinMaxStay $minMaxStay
     * @param \Sabre\BargainFinderMax\Structs\RefundPenalty $refundPenalty
     * @param \Sabre\BargainFinderMax\Structs\PublicFare $publicFare
     * @param \Sabre\BargainFinderMax\Structs\PrivateFare $privateFare
     * @param \Sabre\BargainFinderMax\Structs\Cabin $cabin
     * @param \Sabre\BargainFinderMax\Structs\PassengerType $passengerType
     * @param \Sabre\BargainFinderMax\Structs\NegotiatedFaresOnly $negotiatedFaresOnly
     * @param \Sabre\BargainFinderMax\Structs\XOFares $xOFares
     * @param \Sabre\BargainFinderMax\Structs\UsePassengerFares $usePassengerFares
     * @param \Sabre\BargainFinderMax\Structs\UseNegotiatedFares $useNegotiatedFares
     * @param \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType[] $passengerTypeQuantity
     * @param \Sabre\BargainFinderMax\Structs\JumpCabinLogicType $jumpCabinLogic
     * @param \Sabre\BargainFinderMax\Structs\KeepSameCabinType $keepSameCabin
     * @param \Sabre\BargainFinderMax\Structs\VoluntaryChangesSMPType $voluntaryChanges
     * @param \Sabre\BargainFinderMax\Structs\CorporateID $corporateID
     * @param \Sabre\BargainFinderMax\Structs\AccountCode $accountCode
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\ExcludeRestricted $excludeRestricted = null, \Sabre\BargainFinderMax\Structs\ResTicketing $resTicketing = null, \Sabre\BargainFinderMax\Structs\MinMaxStay $minMaxStay = null, \Sabre\BargainFinderMax\Structs\RefundPenalty $refundPenalty = null, \Sabre\BargainFinderMax\Structs\PublicFare $publicFare = null, \Sabre\BargainFinderMax\Structs\PrivateFare $privateFare = null, \Sabre\BargainFinderMax\Structs\Cabin $cabin = null, \Sabre\BargainFinderMax\Structs\PassengerType $passengerType = null, \Sabre\BargainFinderMax\Structs\NegotiatedFaresOnly $negotiatedFaresOnly = null, \Sabre\BargainFinderMax\Structs\XOFares $xOFares = null, \Sabre\BargainFinderMax\Structs\UsePassengerFares $usePassengerFares = null, \Sabre\BargainFinderMax\Structs\UseNegotiatedFares $useNegotiatedFares = null, array $passengerTypeQuantity = array(), \Sabre\BargainFinderMax\Structs\JumpCabinLogicType $jumpCabinLogic = null, \Sabre\BargainFinderMax\Structs\KeepSameCabinType $keepSameCabin = null, \Sabre\BargainFinderMax\Structs\VoluntaryChangesSMPType $voluntaryChanges = null, \Sabre\BargainFinderMax\Structs\CorporateID $corporateID = null, \Sabre\BargainFinderMax\Structs\AccountCode $accountCode = null)
    {
        $this
            ->setExcludeRestricted($excludeRestricted)
            ->setResTicketing($resTicketing)
            ->setMinMaxStay($minMaxStay)
            ->setRefundPenalty($refundPenalty)
            ->setPublicFare($publicFare)
            ->setPrivateFare($privateFare)
            ->setCabin($cabin)
            ->setPassengerType($passengerType)
            ->setNegotiatedFaresOnly($negotiatedFaresOnly)
            ->setXOFares($xOFares)
            ->setUsePassengerFares($usePassengerFares)
            ->setUseNegotiatedFares($useNegotiatedFares)
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setJumpCabinLogic($jumpCabinLogic)
            ->setKeepSameCabin($keepSameCabin)
            ->setVoluntaryChanges($voluntaryChanges)
            ->setCorporateID($corporateID)
            ->setAccountCode($accountCode);
    }
    /**
     * Get ExcludeRestricted value
     * @return \Sabre\BargainFinderMax\Structs\ExcludeRestricted|null
     */
    public function getExcludeRestricted()
    {
        return $this->ExcludeRestricted;
    }
    /**
     * Set ExcludeRestricted value
     * @param \Sabre\BargainFinderMax\Structs\ExcludeRestricted $excludeRestricted
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setExcludeRestricted(\Sabre\BargainFinderMax\Structs\ExcludeRestricted $excludeRestricted = null)
    {
        $this->ExcludeRestricted = $excludeRestricted;
        return $this;
    }
    /**
     * Get ResTicketing value
     * @return \Sabre\BargainFinderMax\Structs\ResTicketing|null
     */
    public function getResTicketing()
    {
        return $this->ResTicketing;
    }
    /**
     * Set ResTicketing value
     * @param \Sabre\BargainFinderMax\Structs\ResTicketing $resTicketing
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setResTicketing(\Sabre\BargainFinderMax\Structs\ResTicketing $resTicketing = null)
    {
        $this->ResTicketing = $resTicketing;
        return $this;
    }
    /**
     * Get MinMaxStay value
     * @return \Sabre\BargainFinderMax\Structs\MinMaxStay|null
     */
    public function getMinMaxStay()
    {
        return $this->MinMaxStay;
    }
    /**
     * Set MinMaxStay value
     * @param \Sabre\BargainFinderMax\Structs\MinMaxStay $minMaxStay
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setMinMaxStay(\Sabre\BargainFinderMax\Structs\MinMaxStay $minMaxStay = null)
    {
        $this->MinMaxStay = $minMaxStay;
        return $this;
    }
    /**
     * Get RefundPenalty value
     * @return \Sabre\BargainFinderMax\Structs\RefundPenalty|null
     */
    public function getRefundPenalty()
    {
        return $this->RefundPenalty;
    }
    /**
     * Set RefundPenalty value
     * @param \Sabre\BargainFinderMax\Structs\RefundPenalty $refundPenalty
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setRefundPenalty(\Sabre\BargainFinderMax\Structs\RefundPenalty $refundPenalty = null)
    {
        $this->RefundPenalty = $refundPenalty;
        return $this;
    }
    /**
     * Get PublicFare value
     * @return \Sabre\BargainFinderMax\Structs\PublicFare|null
     */
    public function getPublicFare()
    {
        return $this->PublicFare;
    }
    /**
     * Set PublicFare value
     * @param \Sabre\BargainFinderMax\Structs\PublicFare $publicFare
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setPublicFare(\Sabre\BargainFinderMax\Structs\PublicFare $publicFare = null)
    {
        $this->PublicFare = $publicFare;
        return $this;
    }
    /**
     * Get PrivateFare value
     * @return \Sabre\BargainFinderMax\Structs\PrivateFare|null
     */
    public function getPrivateFare()
    {
        return $this->PrivateFare;
    }
    /**
     * Set PrivateFare value
     * @param \Sabre\BargainFinderMax\Structs\PrivateFare $privateFare
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setPrivateFare(\Sabre\BargainFinderMax\Structs\PrivateFare $privateFare = null)
    {
        $this->PrivateFare = $privateFare;
        return $this;
    }
    /**
     * Get Cabin value
     * @return \Sabre\BargainFinderMax\Structs\Cabin|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param \Sabre\BargainFinderMax\Structs\Cabin $cabin
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setCabin(\Sabre\BargainFinderMax\Structs\Cabin $cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return \Sabre\BargainFinderMax\Structs\PassengerType|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param \Sabre\BargainFinderMax\Structs\PassengerType $passengerType
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setPassengerType(\Sabre\BargainFinderMax\Structs\PassengerType $passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get NegotiatedFaresOnly value
     * @return \Sabre\BargainFinderMax\Structs\NegotiatedFaresOnly|null
     */
    public function getNegotiatedFaresOnly()
    {
        return $this->NegotiatedFaresOnly;
    }
    /**
     * Set NegotiatedFaresOnly value
     * @param \Sabre\BargainFinderMax\Structs\NegotiatedFaresOnly $negotiatedFaresOnly
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setNegotiatedFaresOnly(\Sabre\BargainFinderMax\Structs\NegotiatedFaresOnly $negotiatedFaresOnly = null)
    {
        $this->NegotiatedFaresOnly = $negotiatedFaresOnly;
        return $this;
    }
    /**
     * Get XOFares value
     * @return \Sabre\BargainFinderMax\Structs\XOFares|null
     */
    public function getXOFares()
    {
        return $this->XOFares;
    }
    /**
     * Set XOFares value
     * @param \Sabre\BargainFinderMax\Structs\XOFares $xOFares
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setXOFares(\Sabre\BargainFinderMax\Structs\XOFares $xOFares = null)
    {
        $this->XOFares = $xOFares;
        return $this;
    }
    /**
     * Get UsePassengerFares value
     * @return \Sabre\BargainFinderMax\Structs\UsePassengerFares|null
     */
    public function getUsePassengerFares()
    {
        return $this->UsePassengerFares;
    }
    /**
     * Set UsePassengerFares value
     * @param \Sabre\BargainFinderMax\Structs\UsePassengerFares $usePassengerFares
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setUsePassengerFares(\Sabre\BargainFinderMax\Structs\UsePassengerFares $usePassengerFares = null)
    {
        $this->UsePassengerFares = $usePassengerFares;
        return $this;
    }
    /**
     * Get UseNegotiatedFares value
     * @return \Sabre\BargainFinderMax\Structs\UseNegotiatedFares|null
     */
    public function getUseNegotiatedFares()
    {
        return $this->UseNegotiatedFares;
    }
    /**
     * Set UseNegotiatedFares value
     * @param \Sabre\BargainFinderMax\Structs\UseNegotiatedFares $useNegotiatedFares
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setUseNegotiatedFares(\Sabre\BargainFinderMax\Structs\UseNegotiatedFares $useNegotiatedFares = null)
    {
        $this->UseNegotiatedFares = $useNegotiatedFares;
        return $this;
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType[]|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType[] $passengerTypeQuantity
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setPassengerTypeQuantity(array $passengerTypeQuantity = array())
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Add item to PassengerTypeQuantity value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $item
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function addToPassengerTypeQuantity(\Sabre\BargainFinderMax\Structs\PassengerTypeQuantityType $item)
    {
        $this->PassengerTypeQuantity[] = $item;
        return $this;
    }
    /**
     * Get JumpCabinLogic value
     * @return \Sabre\BargainFinderMax\Structs\JumpCabinLogicType|null
     */
    public function getJumpCabinLogic()
    {
        return $this->JumpCabinLogic;
    }
    /**
     * Set JumpCabinLogic value
     * @param \Sabre\BargainFinderMax\Structs\JumpCabinLogicType $jumpCabinLogic
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setJumpCabinLogic(\Sabre\BargainFinderMax\Structs\JumpCabinLogicType $jumpCabinLogic = null)
    {
        $this->JumpCabinLogic = $jumpCabinLogic;
        return $this;
    }
    /**
     * Get KeepSameCabin value
     * @return \Sabre\BargainFinderMax\Structs\KeepSameCabinType|null
     */
    public function getKeepSameCabin()
    {
        return $this->KeepSameCabin;
    }
    /**
     * Set KeepSameCabin value
     * @param \Sabre\BargainFinderMax\Structs\KeepSameCabinType $keepSameCabin
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setKeepSameCabin(\Sabre\BargainFinderMax\Structs\KeepSameCabinType $keepSameCabin = null)
    {
        $this->KeepSameCabin = $keepSameCabin;
        return $this;
    }
    /**
     * Get VoluntaryChanges value
     * @return \Sabre\BargainFinderMax\Structs\VoluntaryChangesSMPType|null
     */
    public function getVoluntaryChanges()
    {
        return $this->VoluntaryChanges;
    }
    /**
     * Set VoluntaryChanges value
     * @param \Sabre\BargainFinderMax\Structs\VoluntaryChangesSMPType $voluntaryChanges
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setVoluntaryChanges(\Sabre\BargainFinderMax\Structs\VoluntaryChangesSMPType $voluntaryChanges = null)
    {
        $this->VoluntaryChanges = $voluntaryChanges;
        return $this;
    }
    /**
     * Get CorporateID value
     * @return \Sabre\BargainFinderMax\Structs\CorporateID|null
     */
    public function getCorporateID()
    {
        return $this->CorporateID;
    }
    /**
     * Set CorporateID value
     * @param \Sabre\BargainFinderMax\Structs\CorporateID $corporateID
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setCorporateID(\Sabre\BargainFinderMax\Structs\CorporateID $corporateID = null)
    {
        $this->CorporateID = $corporateID;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return \Sabre\BargainFinderMax\Structs\AccountCode|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param \Sabre\BargainFinderMax\Structs\AccountCode $accountCode
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public function setAccountCode(\Sabre\BargainFinderMax\Structs\AccountCode $accountCode = null)
    {
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
