<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponentIDType Structs
 * @subpackage Structs
 */
class FareComponentIDType extends AbstractStructBase
{
    /**
     * The Ref
     * Meta informations extracted from the WSDL
     * - documentation: Reference to FareComponentDesc ID
     * - use: required
     * @var int
     */
    public $Ref;
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - documentation: Segment additional data
     * @var \Sabre\BargainFinderMax\Structs\SegmentType
     */
    public $Segment;
    /**
     * The Surface
     * @var mixed
     */
    public $Surface;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxIDType[]
     */
    public $Tax;
    /**
     * The TaxSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[]
     */
    public $TaxSummary;
    /**
     * The BrandFeature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\BrandFeatureIDType[]
     */
    public $BrandFeature;
    /**
     * The TravelCommencementDate
     * Meta informations extracted from the WSDL
     * - documentation: Travel commencement date
     * - use: optional
     * @var string
     */
    public $TravelCommencementDate;
    /**
     * The EffectivePriceDeviation
     * Meta informations extracted from the WSDL
     * - documentation: Effective Price Deviation
     * - use: optional
     * @var float
     */
    public $EffectivePriceDeviation;
    /**
     * Constructor method for FareComponentIDType
     * @uses FareComponentIDType::setRef()
     * @uses FareComponentIDType::setSegment()
     * @uses FareComponentIDType::setSurface()
     * @uses FareComponentIDType::setTax()
     * @uses FareComponentIDType::setTaxSummary()
     * @uses FareComponentIDType::setBrandFeature()
     * @uses FareComponentIDType::setTravelCommencementDate()
     * @uses FareComponentIDType::setEffectivePriceDeviation()
     * @param int $ref
     * @param \Sabre\BargainFinderMax\Structs\SegmentType $segment
     * @param mixed $surface
     * @param \Sabre\BargainFinderMax\Structs\TaxIDType[] $tax
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[] $taxSummary
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureIDType[] $brandFeature
     * @param string $travelCommencementDate
     * @param float $effectivePriceDeviation
     */
    public function __construct($ref = null, \Sabre\BargainFinderMax\Structs\SegmentType $segment = null, $surface = null, array $tax = array(), array $taxSummary = array(), array $brandFeature = array(), $travelCommencementDate = null, $effectivePriceDeviation = null)
    {
        $this
            ->setRef($ref)
            ->setSegment($segment)
            ->setSurface($surface)
            ->setTax($tax)
            ->setTaxSummary($taxSummary)
            ->setBrandFeature($brandFeature)
            ->setTravelCommencementDate($travelCommencementDate)
            ->setEffectivePriceDeviation($effectivePriceDeviation);
    }
    /**
     * Get Ref value
     * @return int
     */
    public function getRef()
    {
        return $this->Ref;
    }
    /**
     * Set Ref value
     * @param int $ref
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function setRef($ref = null)
    {
        $this->Ref = $ref;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\BargainFinderMax\Structs\SegmentType|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param \Sabre\BargainFinderMax\Structs\SegmentType $segment
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function setSegment(\Sabre\BargainFinderMax\Structs\SegmentType $segment = null)
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Get Surface value
     * @return mixed|null
     */
    public function getSurface()
    {
        return $this->Surface;
    }
    /**
     * Set Surface value
     * @param mixed $surface
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function setSurface($surface = null)
    {
        $this->Surface = $surface;
        return $this;
    }
    /**
     * Get Tax value
     * @return \Sabre\BargainFinderMax\Structs\TaxIDType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxIDType[] $tax
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxIDType $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function addToTax(\Sabre\BargainFinderMax\Structs\TaxIDType $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryIDType[] $taxSummary
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TaxSummaryIDType $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function addToTaxSummary(\Sabre\BargainFinderMax\Structs\TaxSummaryIDType $item)
    {
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Get BrandFeature value
     * @return \Sabre\BargainFinderMax\Structs\BrandFeatureIDType[]|null
     */
    public function getBrandFeature()
    {
        return $this->BrandFeature;
    }
    /**
     * Set BrandFeature value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureIDType[] $brandFeature
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function setBrandFeature(array $brandFeature = array())
    {
        $this->BrandFeature = $brandFeature;
        return $this;
    }
    /**
     * Add item to BrandFeature value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\BrandFeatureIDType $item
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function addToBrandFeature(\Sabre\BargainFinderMax\Structs\BrandFeatureIDType $item)
    {
        $this->BrandFeature[] = $item;
        return $this;
    }
    /**
     * Get TravelCommencementDate value
     * @return string|null
     */
    public function getTravelCommencementDate()
    {
        return $this->TravelCommencementDate;
    }
    /**
     * Set TravelCommencementDate value
     * @param string $travelCommencementDate
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function setTravelCommencementDate($travelCommencementDate = null)
    {
        $this->TravelCommencementDate = $travelCommencementDate;
        return $this;
    }
    /**
     * Get EffectivePriceDeviation value
     * @return float|null
     */
    public function getEffectivePriceDeviation()
    {
        return $this->EffectivePriceDeviation;
    }
    /**
     * Set EffectivePriceDeviation value
     * @param float $effectivePriceDeviation
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public function setEffectivePriceDeviation($effectivePriceDeviation = null)
    {
        $this->EffectivePriceDeviation = $effectivePriceDeviation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareComponentIDType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
