<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponentBreakdownType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Fare Component Breakdown
 * @subpackage Structs
 */
class FareComponentBreakdownType extends AbstractStructBase
{
    /**
     * The FareComponentReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: Fare Component Number
     * - use: optional
     * @var int
     */
    public $FareComponentReferenceID;
    /**
     * The FareComponentCommission
     * Meta informations extracted from the WSDL
     * - documentation: Agency Managed Commission per Fare Component | Commission Amount per Fare Component | Used for amounts, max 3 decimals
     * - use: optional
     * - fractionDigits: 3
     * @var float
     */
    public $FareComponentCommission;
    /**
     * The EarnedFareComponentCommission
     * Meta informations extracted from the WSDL
     * - documentation: Agency Managed Earned Commission per Fare Component | Earned Commission Amount per Fare Component | Used for amounts, max 3 decimals
     * - use: optional
     * - fractionDigits: 3
     * @var float
     */
    public $EarnedFareComponentCommission;
    /**
     * The MethodID
     * Meta informations extracted from the WSDL
     * - documentation: Commission method ID | Commission Method ID
     * - use: optional
     * @var int
     */
    public $MethodID;
    /**
     * The RuleID
     * Meta informations extracted from the WSDL
     * - documentation: Commission rule ID | Commission Rule ID
     * - use: optional
     * @var int
     */
    public $RuleID;
    /**
     * The RuleFamilyID
     * Meta informations extracted from the WSDL
     * - documentation: Commission rule family ID | Commission Rule Family ID
     * - use: optional
     * @var int
     */
    public $RuleFamilyID;
    /**
     * The ContractID
     * Meta informations extracted from the WSDL
     * - documentation: Commission contract ID | Commission Contract ID
     * - use: optional
     * @var int
     */
    public $ContractID;
    /**
     * The ContractFamilyID
     * Meta informations extracted from the WSDL
     * - documentation: Commission contract family ID | Commission Contract Family ID
     * - use: optional
     * @var int
     */
    public $ContractFamilyID;
    /**
     * Constructor method for FareComponentBreakdownType
     * @uses FareComponentBreakdownType::setFareComponentReferenceID()
     * @uses FareComponentBreakdownType::setFareComponentCommission()
     * @uses FareComponentBreakdownType::setEarnedFareComponentCommission()
     * @uses FareComponentBreakdownType::setMethodID()
     * @uses FareComponentBreakdownType::setRuleID()
     * @uses FareComponentBreakdownType::setRuleFamilyID()
     * @uses FareComponentBreakdownType::setContractID()
     * @uses FareComponentBreakdownType::setContractFamilyID()
     * @param int $fareComponentReferenceID
     * @param float $fareComponentCommission
     * @param float $earnedFareComponentCommission
     * @param int $methodID
     * @param int $ruleID
     * @param int $ruleFamilyID
     * @param int $contractID
     * @param int $contractFamilyID
     */
    public function __construct($fareComponentReferenceID = null, $fareComponentCommission = null, $earnedFareComponentCommission = null, $methodID = null, $ruleID = null, $ruleFamilyID = null, $contractID = null, $contractFamilyID = null)
    {
        $this
            ->setFareComponentReferenceID($fareComponentReferenceID)
            ->setFareComponentCommission($fareComponentCommission)
            ->setEarnedFareComponentCommission($earnedFareComponentCommission)
            ->setMethodID($methodID)
            ->setRuleID($ruleID)
            ->setRuleFamilyID($ruleFamilyID)
            ->setContractID($contractID)
            ->setContractFamilyID($contractFamilyID);
    }
    /**
     * Get FareComponentReferenceID value
     * @return int|null
     */
    public function getFareComponentReferenceID()
    {
        return $this->FareComponentReferenceID;
    }
    /**
     * Set FareComponentReferenceID value
     * @param int $fareComponentReferenceID
     * @return \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType
     */
    public function setFareComponentReferenceID($fareComponentReferenceID = null)
    {
        $this->FareComponentReferenceID = $fareComponentReferenceID;
        return $this;
    }
    /**
     * Get FareComponentCommission value
     * @return float|null
     */
    public function getFareComponentCommission()
    {
        return $this->FareComponentCommission;
    }
    /**
     * Set FareComponentCommission value
     * @param float $fareComponentCommission
     * @return \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType
     */
    public function setFareComponentCommission($fareComponentCommission = null)
    {
        $this->FareComponentCommission = $fareComponentCommission;
        return $this;
    }
    /**
     * Get EarnedFareComponentCommission value
     * @return float|null
     */
    public function getEarnedFareComponentCommission()
    {
        return $this->EarnedFareComponentCommission;
    }
    /**
     * Set EarnedFareComponentCommission value
     * @param float $earnedFareComponentCommission
     * @return \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType
     */
    public function setEarnedFareComponentCommission($earnedFareComponentCommission = null)
    {
        $this->EarnedFareComponentCommission = $earnedFareComponentCommission;
        return $this;
    }
    /**
     * Get MethodID value
     * @return int|null
     */
    public function getMethodID()
    {
        return $this->MethodID;
    }
    /**
     * Set MethodID value
     * @param int $methodID
     * @return \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType
     */
    public function setMethodID($methodID = null)
    {
        $this->MethodID = $methodID;
        return $this;
    }
    /**
     * Get RuleID value
     * @return int|null
     */
    public function getRuleID()
    {
        return $this->RuleID;
    }
    /**
     * Set RuleID value
     * @param int $ruleID
     * @return \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType
     */
    public function setRuleID($ruleID = null)
    {
        $this->RuleID = $ruleID;
        return $this;
    }
    /**
     * Get RuleFamilyID value
     * @return int|null
     */
    public function getRuleFamilyID()
    {
        return $this->RuleFamilyID;
    }
    /**
     * Set RuleFamilyID value
     * @param int $ruleFamilyID
     * @return \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType
     */
    public function setRuleFamilyID($ruleFamilyID = null)
    {
        $this->RuleFamilyID = $ruleFamilyID;
        return $this;
    }
    /**
     * Get ContractID value
     * @return int|null
     */
    public function getContractID()
    {
        return $this->ContractID;
    }
    /**
     * Set ContractID value
     * @param int $contractID
     * @return \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType
     */
    public function setContractID($contractID = null)
    {
        $this->ContractID = $contractID;
        return $this;
    }
    /**
     * Get ContractFamilyID value
     * @return int|null
     */
    public function getContractFamilyID()
    {
        return $this->ContractFamilyID;
    }
    /**
     * Set ContractFamilyID value
     * @param int $contractFamilyID
     * @return \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType
     */
    public function setContractFamilyID($contractFamilyID = null)
    {
        $this->ContractFamilyID = $contractFamilyID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareComponentBreakdownType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
