<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareBasisCode Structs
 * Meta informations extracted from the WSDL
 * - documentation: Fare basis code for the price for this PTC | Used for Character Strings, length 1 to 16
 * - maxLength: 16
 * - minLength: 1
 * @subpackage Structs
 */
class FareBasisCode extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The PrivateFareType
     * @var string
     */
    public $PrivateFareType;
    /**
     * The FareComponentReferenceID
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $FareComponentReferenceID;
    /**
     * The AccountCode
     * Meta informations extracted from the WSDL
     * - documentation: Matched Account Code | Used for Character Strings, length 1 to 20
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $AccountCode;
    /**
     * The Mileage
     * Meta informations extracted from the WSDL
     * - documentation: Mileage (AWARD Shopping)
     * @var int
     */
    public $Mileage;
    /**
     * The BookingCode
     * @var string
     */
    public $BookingCode;
    /**
     * The AvailabilityBreak
     * Meta informations extracted from the WSDL
     * - documentation: Availability break after this segment
     * @var bool
     */
    public $AvailabilityBreak;
    /**
     * The DepartureAirportCode
     * @var string
     */
    public $DepartureAirportCode;
    /**
     * The ArrivalAirportCode
     * @var string
     */
    public $ArrivalAirportCode;
    /**
     * The FareComponentBeginAirport
     * Meta informations extracted from the WSDL
     * - documentation: If this attribute is present, the enclosing FareBasisCode element is the first portion of a new fare component. It represents the origin airport of the fare component. | Airport code type
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * - use: optional
     * @var string
     */
    public $FareComponentBeginAirport;
    /**
     * The FareComponentEndAirport
     * Meta informations extracted from the WSDL
     * - documentation: If this attribute is present, the enclosing FareBasisCode element is the first portion of a new fare component. It represents the destination airport of the fare component. | Airport code type
     * - length: 3
     * - pattern: [A-Z]{3}
     * - type: UpperCaseAlphaNumericLength3to5
     * - use: optional
     * @var string
     */
    public $FareComponentEndAirport;
    /**
     * The FareComponentDirectionality
     * Meta informations extracted from the WSDL
     * - documentation: If this attribute is present, the enclosing FareBasisCode element is the first portion of a new fare component. If its value is "FROM" it means that fare component origin and destination are ordered the same as the departure and
     * arival airports of the leg. Value "TO" means the opposite ordering of fare component origin and destination.
     * @var string
     */
    public $FareComponentDirectionality;
    /**
     * The FareComponentVendorCode
     * Meta informations extracted from the WSDL
     * - documentation: Used to specify fare source | Used for Character Strings, length 1 to 4
     * - use: optional
     * - maxLength: 4
     * - minLength: 1
     * @var string
     */
    public $FareComponentVendorCode;
    /**
     * The GovCarrier
     * Meta informations extracted from the WSDL
     * - documentation: Governing carrier
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $GovCarrier;
    /**
     * Constructor method for FareBasisCode
     * @uses FareBasisCode::set_()
     * @uses FareBasisCode::setPrivateFareType()
     * @uses FareBasisCode::setFareComponentReferenceID()
     * @uses FareBasisCode::setAccountCode()
     * @uses FareBasisCode::setMileage()
     * @uses FareBasisCode::setBookingCode()
     * @uses FareBasisCode::setAvailabilityBreak()
     * @uses FareBasisCode::setDepartureAirportCode()
     * @uses FareBasisCode::setArrivalAirportCode()
     * @uses FareBasisCode::setFareComponentBeginAirport()
     * @uses FareBasisCode::setFareComponentEndAirport()
     * @uses FareBasisCode::setFareComponentDirectionality()
     * @uses FareBasisCode::setFareComponentVendorCode()
     * @uses FareBasisCode::setGovCarrier()
     * @param string $_
     * @param string $privateFareType
     * @param int $fareComponentReferenceID
     * @param string $accountCode
     * @param int $mileage
     * @param string $bookingCode
     * @param bool $availabilityBreak
     * @param string $departureAirportCode
     * @param string $arrivalAirportCode
     * @param string $fareComponentBeginAirport
     * @param string $fareComponentEndAirport
     * @param string $fareComponentDirectionality
     * @param string $fareComponentVendorCode
     * @param string $govCarrier
     */
    public function __construct($_ = null, $privateFareType = null, $fareComponentReferenceID = null, $accountCode = null, $mileage = null, $bookingCode = null, $availabilityBreak = null, $departureAirportCode = null, $arrivalAirportCode = null, $fareComponentBeginAirport = null, $fareComponentEndAirport = null, $fareComponentDirectionality = null, $fareComponentVendorCode = null, $govCarrier = null)
    {
        $this
            ->set_($_)
            ->setPrivateFareType($privateFareType)
            ->setFareComponentReferenceID($fareComponentReferenceID)
            ->setAccountCode($accountCode)
            ->setMileage($mileage)
            ->setBookingCode($bookingCode)
            ->setAvailabilityBreak($availabilityBreak)
            ->setDepartureAirportCode($departureAirportCode)
            ->setArrivalAirportCode($arrivalAirportCode)
            ->setFareComponentBeginAirport($fareComponentBeginAirport)
            ->setFareComponentEndAirport($fareComponentEndAirport)
            ->setFareComponentDirectionality($fareComponentDirectionality)
            ->setFareComponentVendorCode($fareComponentVendorCode)
            ->setGovCarrier($govCarrier);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PrivateFareType value
     * @return string|null
     */
    public function getPrivateFareType()
    {
        return $this->PrivateFareType;
    }
    /**
     * Set PrivateFareType value
     * @param string $privateFareType
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setPrivateFareType($privateFareType = null)
    {
        $this->PrivateFareType = $privateFareType;
        return $this;
    }
    /**
     * Get FareComponentReferenceID value
     * @return int|null
     */
    public function getFareComponentReferenceID()
    {
        return $this->FareComponentReferenceID;
    }
    /**
     * Set FareComponentReferenceID value
     * @param int $fareComponentReferenceID
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setFareComponentReferenceID($fareComponentReferenceID = null)
    {
        $this->FareComponentReferenceID = $fareComponentReferenceID;
        return $this;
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setAccountCode($accountCode = null)
    {
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get Mileage value
     * @return int|null
     */
    public function getMileage()
    {
        return $this->Mileage;
    }
    /**
     * Set Mileage value
     * @param int $mileage
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setMileage($mileage = null)
    {
        $this->Mileage = $mileage;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setBookingCode($bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get AvailabilityBreak value
     * @return bool|null
     */
    public function getAvailabilityBreak()
    {
        return $this->AvailabilityBreak;
    }
    /**
     * Set AvailabilityBreak value
     * @param bool $availabilityBreak
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setAvailabilityBreak($availabilityBreak = null)
    {
        $this->AvailabilityBreak = $availabilityBreak;
        return $this;
    }
    /**
     * Get DepartureAirportCode value
     * @return string|null
     */
    public function getDepartureAirportCode()
    {
        return $this->DepartureAirportCode;
    }
    /**
     * Set DepartureAirportCode value
     * @param string $departureAirportCode
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setDepartureAirportCode($departureAirportCode = null)
    {
        $this->DepartureAirportCode = $departureAirportCode;
        return $this;
    }
    /**
     * Get ArrivalAirportCode value
     * @return string|null
     */
    public function getArrivalAirportCode()
    {
        return $this->ArrivalAirportCode;
    }
    /**
     * Set ArrivalAirportCode value
     * @param string $arrivalAirportCode
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setArrivalAirportCode($arrivalAirportCode = null)
    {
        $this->ArrivalAirportCode = $arrivalAirportCode;
        return $this;
    }
    /**
     * Get FareComponentBeginAirport value
     * @return string|null
     */
    public function getFareComponentBeginAirport()
    {
        return $this->FareComponentBeginAirport;
    }
    /**
     * Set FareComponentBeginAirport value
     * @param string $fareComponentBeginAirport
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setFareComponentBeginAirport($fareComponentBeginAirport = null)
    {
        $this->FareComponentBeginAirport = $fareComponentBeginAirport;
        return $this;
    }
    /**
     * Get FareComponentEndAirport value
     * @return string|null
     */
    public function getFareComponentEndAirport()
    {
        return $this->FareComponentEndAirport;
    }
    /**
     * Set FareComponentEndAirport value
     * @param string $fareComponentEndAirport
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setFareComponentEndAirport($fareComponentEndAirport = null)
    {
        $this->FareComponentEndAirport = $fareComponentEndAirport;
        return $this;
    }
    /**
     * Get FareComponentDirectionality value
     * @return string|null
     */
    public function getFareComponentDirectionality()
    {
        return $this->FareComponentDirectionality;
    }
    /**
     * Set FareComponentDirectionality value
     * @uses \Sabre\BargainFinderMax\Enums\FareDirectionality::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\FareDirectionality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareComponentDirectionality
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setFareComponentDirectionality($fareComponentDirectionality = null)
    {
        $this->FareComponentDirectionality = $fareComponentDirectionality;
        return $this;
    }
    /**
     * Get FareComponentVendorCode value
     * @return string|null
     */
    public function getFareComponentVendorCode()
    {
        return $this->FareComponentVendorCode;
    }
    /**
     * Set FareComponentVendorCode value
     * @param string $fareComponentVendorCode
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setFareComponentVendorCode($fareComponentVendorCode = null)
    {
        $this->FareComponentVendorCode = $fareComponentVendorCode;
        return $this;
    }
    /**
     * Get GovCarrier value
     * @return string|null
     */
    public function getGovCarrier()
    {
        return $this->GovCarrier;
    }
    /**
     * Set GovCarrier value
     * @param string $govCarrier
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public function setGovCarrier($govCarrier = null)
    {
        $this->GovCarrier = $govCarrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareBasisCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
