<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareAdjustment Structs
 * Meta informations extracted from the WSDL
 * - documentation: Capability to specify Plus-Up and Discount Amount and Percentage.
 * @subpackage Structs
 */
class FareAdjustment extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - documentation: Adjustment Value, can be positive or negative, number or percentage
     * - use: required
     * - pattern: (\+|-)?([0-9]+(\.[0-9]*)?|\.[0-9]+)%?
     * @var string
     */
    public $Value;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: Currency of Adjustment's Value | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for FareAdjustment
     * @uses FareAdjustment::setValue()
     * @uses FareAdjustment::setCurrency()
     * @param string $value
     * @param string $currency
     */
    public function __construct($value = null, $currency = null)
    {
        $this
            ->setValue($value)
            ->setCurrency($currency);
    }
    /**
     * Get Value value
     * @return string
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Sabre\BargainFinderMax\Structs\FareAdjustment
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\BargainFinderMax\Structs\FareAdjustment
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\FareAdjustment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
