<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeSourceType Structs
 * @subpackage Structs
 */
class ExchangeSourceType extends AbstractStructBase
{
    /**
     * The BookingChannel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SourceBookingChannelType
     */
    public $BookingChannel;
    /**
     * The AgentSine
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the party within the requesting entity. | Identifies the party within the requesting entity. | Used for Character Strings, length 1 to 16
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $AgentSine;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system. | An identification code assigned to an office/agency by a reservation system. | Used for Character Strings, length 1 to 16
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The ISOCountry
     * Meta informations extracted from the WSDL
     * - documentation: The country code of the requesting party. | The country code of the requesting party. | 2 character country code as defined in ISO3166.
     * - pattern: [a-zA-Z]{2}
     * @var string
     */
    public $ISOCountry;
    /**
     * The ISOCurrency
     * Meta informations extracted from the WSDL
     * - documentation: The currency code in which the reservation will be ticketed. | The currency code in which the reservation will be ticketed. | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $ISOCurrency;
    /**
     * The AgentDutyCode
     * Meta informations extracted from the WSDL
     * - documentation: An authority code assigned to a requestor. | An authority code assigned to a requestor. | Used for Character Strings, length 1 to 16
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The AirlineVendorID
     * Meta informations extracted from the WSDL
     * - documentation: The IATA assigned airline code. | The IATA assigned airline code. | Used for an Upper Alpha String and Numeric, length 2 to 3.
     * - pattern: [A-Z0-9]{2,3}
     * @var string
     */
    public $AirlineVendorID;
    /**
     * The AirportCode
     * Meta informations extracted from the WSDL
     * - documentation: The IATA assigned airport code. | The IATA assigned airport code. | Used for an Upper Alpha String and Numeric, length 3 to 5.
     * - pattern: [A-Z0-9]{3,5}
     * @var string
     */
    public $AirportCode;
    /**
     * The FirstDepartPoint
     * Meta informations extracted from the WSDL
     * - documentation: The point of first departure in a trip. | The point of first departure in a trip. | Used for Strings, length exactly 3
     * - maxLength: 3
     * - minLength: 3
     * @var string
     */
    public $FirstDepartPoint;
    /**
     * The ERSP_UserID
     * Meta informations extracted from the WSDL
     * - documentation: Electronic Reservation Service Provider (ERSP) assigned identifier used to identify the individual using the ERSP system. | Electronic Reservation Service Provider (ERSP) assigned identifier used to identify the individual using the
     * ERSP system. | Used for Character Strings, length 1 to 16
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $ERSP_UserID;
    /**
     * The PersonalCityCode
     * @var string
     */
    public $PersonalCityCode;
    /**
     * The AccountingCode
     * @var string
     */
    public $AccountingCode;
    /**
     * The OfficeCode
     * @var string
     */
    public $OfficeCode;
    /**
     * The DefaultTicketingCarrier
     * @var string
     */
    public $DefaultTicketingCarrier;
    /**
     * The AirlineChannelCode
     * @var string
     */
    public $AirlineChannelCode;
    /**
     * The AgentDepartmentCode
     * Meta informations extracted from the WSDL
     * - documentation: Agent department code | Agent department code
     * - maxLength: 6
     * @var string
     */
    public $AgentDepartmentCode;
    /**
     * The AgentFunction
     * Meta informations extracted from the WSDL
     * - documentation: Agent function | Agent function
     * - maxLength: 3
     * @var string
     */
    public $AgentFunction;
    /**
     * The TravelAgencyIATA
     * Meta informations extracted from the WSDL
     * - documentation: Travel agency IATA | Travel agency IATA
     * - pattern: [0-9]{1,14}
     * @var string
     */
    public $TravelAgencyIATA;
    /**
     * The HomeAgencyIATA
     * Meta informations extracted from the WSDL
     * - documentation: Home agency IATA | Home agency IATA
     * - pattern: [0-9]{1,14}
     * @var string
     */
    public $HomeAgencyIATA;
    /**
     * The AgentIATA
     * Meta informations extracted from the WSDL
     * - documentation: Agent IATA | Agent IATA
     * - pattern: [0-9]{1,14}
     * @var string
     */
    public $AgentIATA;
    /**
     * The VendorCRSCode
     * Meta informations extracted from the WSDL
     * - documentation: Vendor CRS code | Vendor CRS code
     * @var string
     */
    public $VendorCRSCode;
    /**
     * The AgentDuty
     * Meta informations extracted from the WSDL
     * - documentation: Agent duty | Agent duty | Used for Characters, length 1 | Used for Characters, length 1
     * - length: 1
     * @var string
     */
    public $AgentDuty;
    /**
     * The AbacusUser
     * Meta informations extracted from the WSDL
     * - documentation: Abacus user | Abacus user
     * @var bool
     */
    public $AbacusUser;
    /**
     * The AgentCity
     * Meta informations extracted from the WSDL
     * - documentation: Agent city | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $AgentCity;
    /**
     * The MainTravelAgencyPCC
     * Meta informations extracted from the WSDL
     * - documentation: Main travel agency PCC | Used for Character Strings, length 1 to 16
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $MainTravelAgencyPCC;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - documentation: Carrier
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $Carrier;
    /**
     * The HostCarrier
     * Meta informations extracted from the WSDL
     * - documentation: PCC Host Carrier
     * - pattern: [0-9A-Z]{2,3}
     * @var string
     */
    public $HostCarrier;
    /**
     * The ETicketCapable
     * Meta informations extracted from the WSDL
     * - documentation: Agency is Eticket capable
     * @var bool
     */
    public $ETicketCapable;
    /**
     * The CoHostID
     * Meta informations extracted from the WSDL
     * - documentation: CoHostID
     * @var int
     */
    public $CoHostID;
    /**
     * Constructor method for ExchangeSourceType
     * @uses ExchangeSourceType::setBookingChannel()
     * @uses ExchangeSourceType::setAgentSine()
     * @uses ExchangeSourceType::setPseudoCityCode()
     * @uses ExchangeSourceType::setISOCountry()
     * @uses ExchangeSourceType::setISOCurrency()
     * @uses ExchangeSourceType::setAgentDutyCode()
     * @uses ExchangeSourceType::setAirlineVendorID()
     * @uses ExchangeSourceType::setAirportCode()
     * @uses ExchangeSourceType::setFirstDepartPoint()
     * @uses ExchangeSourceType::setERSP_UserID()
     * @uses ExchangeSourceType::setPersonalCityCode()
     * @uses ExchangeSourceType::setAccountingCode()
     * @uses ExchangeSourceType::setOfficeCode()
     * @uses ExchangeSourceType::setDefaultTicketingCarrier()
     * @uses ExchangeSourceType::setAirlineChannelCode()
     * @uses ExchangeSourceType::setAgentDepartmentCode()
     * @uses ExchangeSourceType::setAgentFunction()
     * @uses ExchangeSourceType::setTravelAgencyIATA()
     * @uses ExchangeSourceType::setHomeAgencyIATA()
     * @uses ExchangeSourceType::setAgentIATA()
     * @uses ExchangeSourceType::setVendorCRSCode()
     * @uses ExchangeSourceType::setAgentDuty()
     * @uses ExchangeSourceType::setAbacusUser()
     * @uses ExchangeSourceType::setAgentCity()
     * @uses ExchangeSourceType::setMainTravelAgencyPCC()
     * @uses ExchangeSourceType::setCarrier()
     * @uses ExchangeSourceType::setHostCarrier()
     * @uses ExchangeSourceType::setETicketCapable()
     * @uses ExchangeSourceType::setCoHostID()
     * @param \Sabre\BargainFinderMax\Structs\SourceBookingChannelType $bookingChannel
     * @param string $agentSine
     * @param string $pseudoCityCode
     * @param string $iSOCountry
     * @param string $iSOCurrency
     * @param string $agentDutyCode
     * @param string $airlineVendorID
     * @param string $airportCode
     * @param string $firstDepartPoint
     * @param string $eRSP_UserID
     * @param string $personalCityCode
     * @param string $accountingCode
     * @param string $officeCode
     * @param string $defaultTicketingCarrier
     * @param string $airlineChannelCode
     * @param string $agentDepartmentCode
     * @param string $agentFunction
     * @param string $travelAgencyIATA
     * @param string $homeAgencyIATA
     * @param string $agentIATA
     * @param string $vendorCRSCode
     * @param string $agentDuty
     * @param bool $abacusUser
     * @param string $agentCity
     * @param string $mainTravelAgencyPCC
     * @param string $carrier
     * @param string $hostCarrier
     * @param bool $eTicketCapable
     * @param int $coHostID
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\SourceBookingChannelType $bookingChannel = null, $agentSine = null, $pseudoCityCode = null, $iSOCountry = null, $iSOCurrency = null, $agentDutyCode = null, $airlineVendorID = null, $airportCode = null, $firstDepartPoint = null, $eRSP_UserID = null, $personalCityCode = null, $accountingCode = null, $officeCode = null, $defaultTicketingCarrier = null, $airlineChannelCode = null, $agentDepartmentCode = null, $agentFunction = null, $travelAgencyIATA = null, $homeAgencyIATA = null, $agentIATA = null, $vendorCRSCode = null, $agentDuty = null, $abacusUser = null, $agentCity = null, $mainTravelAgencyPCC = null, $carrier = null, $hostCarrier = null, $eTicketCapable = null, $coHostID = null)
    {
        $this
            ->setBookingChannel($bookingChannel)
            ->setAgentSine($agentSine)
            ->setPseudoCityCode($pseudoCityCode)
            ->setISOCountry($iSOCountry)
            ->setISOCurrency($iSOCurrency)
            ->setAgentDutyCode($agentDutyCode)
            ->setAirlineVendorID($airlineVendorID)
            ->setAirportCode($airportCode)
            ->setFirstDepartPoint($firstDepartPoint)
            ->setERSP_UserID($eRSP_UserID)
            ->setPersonalCityCode($personalCityCode)
            ->setAccountingCode($accountingCode)
            ->setOfficeCode($officeCode)
            ->setDefaultTicketingCarrier($defaultTicketingCarrier)
            ->setAirlineChannelCode($airlineChannelCode)
            ->setAgentDepartmentCode($agentDepartmentCode)
            ->setAgentFunction($agentFunction)
            ->setTravelAgencyIATA($travelAgencyIATA)
            ->setHomeAgencyIATA($homeAgencyIATA)
            ->setAgentIATA($agentIATA)
            ->setVendorCRSCode($vendorCRSCode)
            ->setAgentDuty($agentDuty)
            ->setAbacusUser($abacusUser)
            ->setAgentCity($agentCity)
            ->setMainTravelAgencyPCC($mainTravelAgencyPCC)
            ->setCarrier($carrier)
            ->setHostCarrier($hostCarrier)
            ->setETicketCapable($eTicketCapable)
            ->setCoHostID($coHostID);
    }
    /**
     * Get BookingChannel value
     * @return \Sabre\BargainFinderMax\Structs\SourceBookingChannelType|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \Sabre\BargainFinderMax\Structs\SourceBookingChannelType $bookingChannel
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setBookingChannel(\Sabre\BargainFinderMax\Structs\SourceBookingChannelType $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Get AgentSine value
     * @return string|null
     */
    public function getAgentSine()
    {
        return $this->AgentSine;
    }
    /**
     * Set AgentSine value
     * @param string $agentSine
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAgentSine($agentSine = null)
    {
        $this->AgentSine = $agentSine;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get ISOCountry value
     * @return string|null
     */
    public function getISOCountry()
    {
        return $this->ISOCountry;
    }
    /**
     * Set ISOCountry value
     * @param string $iSOCountry
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setISOCountry($iSOCountry = null)
    {
        $this->ISOCountry = $iSOCountry;
        return $this;
    }
    /**
     * Get ISOCurrency value
     * @return string|null
     */
    public function getISOCurrency()
    {
        return $this->ISOCurrency;
    }
    /**
     * Set ISOCurrency value
     * @param string $iSOCurrency
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setISOCurrency($iSOCurrency = null)
    {
        $this->ISOCurrency = $iSOCurrency;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get AirlineVendorID value
     * @return string|null
     */
    public function getAirlineVendorID()
    {
        return $this->AirlineVendorID;
    }
    /**
     * Set AirlineVendorID value
     * @param string $airlineVendorID
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAirlineVendorID($airlineVendorID = null)
    {
        $this->AirlineVendorID = $airlineVendorID;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAirportCode($airportCode = null)
    {
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get FirstDepartPoint value
     * @return string|null
     */
    public function getFirstDepartPoint()
    {
        return $this->FirstDepartPoint;
    }
    /**
     * Set FirstDepartPoint value
     * @param string $firstDepartPoint
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setFirstDepartPoint($firstDepartPoint = null)
    {
        $this->FirstDepartPoint = $firstDepartPoint;
        return $this;
    }
    /**
     * Get ERSP_UserID value
     * @return string|null
     */
    public function getERSP_UserID()
    {
        return $this->ERSP_UserID;
    }
    /**
     * Set ERSP_UserID value
     * @param string $eRSP_UserID
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setERSP_UserID($eRSP_UserID = null)
    {
        $this->ERSP_UserID = $eRSP_UserID;
        return $this;
    }
    /**
     * Get PersonalCityCode value
     * @return string|null
     */
    public function getPersonalCityCode()
    {
        return $this->PersonalCityCode;
    }
    /**
     * Set PersonalCityCode value
     * @param string $personalCityCode
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setPersonalCityCode($personalCityCode = null)
    {
        $this->PersonalCityCode = $personalCityCode;
        return $this;
    }
    /**
     * Get AccountingCode value
     * @return string|null
     */
    public function getAccountingCode()
    {
        return $this->AccountingCode;
    }
    /**
     * Set AccountingCode value
     * @param string $accountingCode
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAccountingCode($accountingCode = null)
    {
        $this->AccountingCode = $accountingCode;
        return $this;
    }
    /**
     * Get OfficeCode value
     * @return string|null
     */
    public function getOfficeCode()
    {
        return $this->OfficeCode;
    }
    /**
     * Set OfficeCode value
     * @param string $officeCode
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setOfficeCode($officeCode = null)
    {
        $this->OfficeCode = $officeCode;
        return $this;
    }
    /**
     * Get DefaultTicketingCarrier value
     * @return string|null
     */
    public function getDefaultTicketingCarrier()
    {
        return $this->DefaultTicketingCarrier;
    }
    /**
     * Set DefaultTicketingCarrier value
     * @param string $defaultTicketingCarrier
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setDefaultTicketingCarrier($defaultTicketingCarrier = null)
    {
        $this->DefaultTicketingCarrier = $defaultTicketingCarrier;
        return $this;
    }
    /**
     * Get AirlineChannelCode value
     * @return string|null
     */
    public function getAirlineChannelCode()
    {
        return $this->AirlineChannelCode;
    }
    /**
     * Set AirlineChannelCode value
     * @param string $airlineChannelCode
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAirlineChannelCode($airlineChannelCode = null)
    {
        $this->AirlineChannelCode = $airlineChannelCode;
        return $this;
    }
    /**
     * Get AgentDepartmentCode value
     * @return string|null
     */
    public function getAgentDepartmentCode()
    {
        return $this->AgentDepartmentCode;
    }
    /**
     * Set AgentDepartmentCode value
     * @param string $agentDepartmentCode
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAgentDepartmentCode($agentDepartmentCode = null)
    {
        $this->AgentDepartmentCode = $agentDepartmentCode;
        return $this;
    }
    /**
     * Get AgentFunction value
     * @return string|null
     */
    public function getAgentFunction()
    {
        return $this->AgentFunction;
    }
    /**
     * Set AgentFunction value
     * @param string $agentFunction
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAgentFunction($agentFunction = null)
    {
        $this->AgentFunction = $agentFunction;
        return $this;
    }
    /**
     * Get TravelAgencyIATA value
     * @return string|null
     */
    public function getTravelAgencyIATA()
    {
        return $this->TravelAgencyIATA;
    }
    /**
     * Set TravelAgencyIATA value
     * @param string $travelAgencyIATA
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setTravelAgencyIATA($travelAgencyIATA = null)
    {
        $this->TravelAgencyIATA = $travelAgencyIATA;
        return $this;
    }
    /**
     * Get HomeAgencyIATA value
     * @return string|null
     */
    public function getHomeAgencyIATA()
    {
        return $this->HomeAgencyIATA;
    }
    /**
     * Set HomeAgencyIATA value
     * @param string $homeAgencyIATA
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setHomeAgencyIATA($homeAgencyIATA = null)
    {
        $this->HomeAgencyIATA = $homeAgencyIATA;
        return $this;
    }
    /**
     * Get AgentIATA value
     * @return string|null
     */
    public function getAgentIATA()
    {
        return $this->AgentIATA;
    }
    /**
     * Set AgentIATA value
     * @param string $agentIATA
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAgentIATA($agentIATA = null)
    {
        $this->AgentIATA = $agentIATA;
        return $this;
    }
    /**
     * Get VendorCRSCode value
     * @return string|null
     */
    public function getVendorCRSCode()
    {
        return $this->VendorCRSCode;
    }
    /**
     * Set VendorCRSCode value
     * @param string $vendorCRSCode
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setVendorCRSCode($vendorCRSCode = null)
    {
        $this->VendorCRSCode = $vendorCRSCode;
        return $this;
    }
    /**
     * Get AgentDuty value
     * @return string|null
     */
    public function getAgentDuty()
    {
        return $this->AgentDuty;
    }
    /**
     * Set AgentDuty value
     * @param string $agentDuty
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAgentDuty($agentDuty = null)
    {
        $this->AgentDuty = $agentDuty;
        return $this;
    }
    /**
     * Get AbacusUser value
     * @return bool|null
     */
    public function getAbacusUser()
    {
        return $this->AbacusUser;
    }
    /**
     * Set AbacusUser value
     * @param bool $abacusUser
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAbacusUser($abacusUser = null)
    {
        $this->AbacusUser = $abacusUser;
        return $this;
    }
    /**
     * Get AgentCity value
     * @return string|null
     */
    public function getAgentCity()
    {
        return $this->AgentCity;
    }
    /**
     * Set AgentCity value
     * @param string $agentCity
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setAgentCity($agentCity = null)
    {
        $this->AgentCity = $agentCity;
        return $this;
    }
    /**
     * Get MainTravelAgencyPCC value
     * @return string|null
     */
    public function getMainTravelAgencyPCC()
    {
        return $this->MainTravelAgencyPCC;
    }
    /**
     * Set MainTravelAgencyPCC value
     * @param string $mainTravelAgencyPCC
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setMainTravelAgencyPCC($mainTravelAgencyPCC = null)
    {
        $this->MainTravelAgencyPCC = $mainTravelAgencyPCC;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setCarrier($carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get HostCarrier value
     * @return string|null
     */
    public function getHostCarrier()
    {
        return $this->HostCarrier;
    }
    /**
     * Set HostCarrier value
     * @param string $hostCarrier
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setHostCarrier($hostCarrier = null)
    {
        $this->HostCarrier = $hostCarrier;
        return $this;
    }
    /**
     * Get ETicketCapable value
     * @return bool|null
     */
    public function getETicketCapable()
    {
        return $this->ETicketCapable;
    }
    /**
     * Set ETicketCapable value
     * @param bool $eTicketCapable
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setETicketCapable($eTicketCapable = null)
    {
        $this->ETicketCapable = $eTicketCapable;
        return $this;
    }
    /**
     * Get CoHostID value
     * @return int|null
     */
    public function getCoHostID()
    {
        return $this->CoHostID;
    }
    /**
     * Set CoHostID value
     * @param int $coHostID
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public function setCoHostID($coHostID = null)
    {
        $this->CoHostID = $coHostID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ExchangeSourceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
