<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeOriginDestinationInformationType Structs
 * @subpackage Structs
 */
class ExchangeOriginDestinationInformationType extends OriginDestinationInformationType
{
    /**
     * The Flight
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationFlightType[]
     */
    public $Flight;
    /**
     * The DateFlexibility
     * @var \Sabre\BargainFinderMax\Structs\DateFlexibility
     */
    public $DateFlexibility;
    /**
     * The SisterDestinationLocation
     * @var \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType
     */
    public $SisterDestinationLocation;
    /**
     * The SisterDestinationMileage
     * @var \Sabre\BargainFinderMax\Structs\SisterDestinationMileage
     */
    public $SisterDestinationMileage;
    /**
     * The SisterOriginLocation
     * @var \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType
     */
    public $SisterOriginLocation;
    /**
     * The SisterOriginMileage
     * @var \Sabre\BargainFinderMax\Structs\SisterOriginMileage
     */
    public $SisterOriginMileage;
    /**
     * The SegmentType
     * @var \Sabre\BargainFinderMax\Structs\SegmentType
     */
    public $SegmentType;
    /**
     * The AlternateTime
     * @var \Sabre\BargainFinderMax\Structs\AlternateTime
     */
    public $AlternateTime;
    /**
     * The MaxOneWayOptions
     * @var \Sabre\BargainFinderMax\Structs\MaxOneWayOptions
     */
    public $MaxOneWayOptions;
    /**
     * The NumOneWayOptions
     * @var \Sabre\BargainFinderMax\Structs\NumOneWayOptions
     */
    public $NumOneWayOptions;
    /**
     * The CabinPref
     * @var \Sabre\BargainFinderMax\Structs\CabinPrefType
     */
    public $CabinPref;
    /**
     * The ConnectionTime
     * @var \Sabre\BargainFinderMax\Structs\ConnectionTime
     */
    public $ConnectionTime;
    /**
     * The TotalTravelTime
     * @var \Sabre\BargainFinderMax\Structs\TotalTravelTime
     */
    public $TotalTravelTime;
    /**
     * Constructor method for ExchangeOriginDestinationInformationType
     * @uses ExchangeOriginDestinationInformationType::setFlight()
     * @uses ExchangeOriginDestinationInformationType::setDateFlexibility()
     * @uses ExchangeOriginDestinationInformationType::setSisterDestinationLocation()
     * @uses ExchangeOriginDestinationInformationType::setSisterDestinationMileage()
     * @uses ExchangeOriginDestinationInformationType::setSisterOriginLocation()
     * @uses ExchangeOriginDestinationInformationType::setSisterOriginMileage()
     * @uses ExchangeOriginDestinationInformationType::setSegmentType()
     * @uses ExchangeOriginDestinationInformationType::setAlternateTime()
     * @uses ExchangeOriginDestinationInformationType::setMaxOneWayOptions()
     * @uses ExchangeOriginDestinationInformationType::setNumOneWayOptions()
     * @uses ExchangeOriginDestinationInformationType::setCabinPref()
     * @uses ExchangeOriginDestinationInformationType::setConnectionTime()
     * @uses ExchangeOriginDestinationInformationType::setTotalTravelTime()
     * @param \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationFlightType[] $flight
     * @param \Sabre\BargainFinderMax\Structs\DateFlexibility $dateFlexibility
     * @param \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $sisterDestinationLocation
     * @param \Sabre\BargainFinderMax\Structs\SisterDestinationMileage $sisterDestinationMileage
     * @param \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $sisterOriginLocation
     * @param \Sabre\BargainFinderMax\Structs\SisterOriginMileage $sisterOriginMileage
     * @param \Sabre\BargainFinderMax\Structs\SegmentType $segmentType
     * @param \Sabre\BargainFinderMax\Structs\AlternateTime $alternateTime
     * @param \Sabre\BargainFinderMax\Structs\MaxOneWayOptions $maxOneWayOptions
     * @param \Sabre\BargainFinderMax\Structs\NumOneWayOptions $numOneWayOptions
     * @param \Sabre\BargainFinderMax\Structs\CabinPrefType $cabinPref
     * @param \Sabre\BargainFinderMax\Structs\ConnectionTime $connectionTime
     * @param \Sabre\BargainFinderMax\Structs\TotalTravelTime $totalTravelTime
     */
    public function __construct(array $flight = array(), \Sabre\BargainFinderMax\Structs\DateFlexibility $dateFlexibility = null, \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $sisterDestinationLocation = null, \Sabre\BargainFinderMax\Structs\SisterDestinationMileage $sisterDestinationMileage = null, \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $sisterOriginLocation = null, \Sabre\BargainFinderMax\Structs\SisterOriginMileage $sisterOriginMileage = null, \Sabre\BargainFinderMax\Structs\SegmentType $segmentType = null, \Sabre\BargainFinderMax\Structs\AlternateTime $alternateTime = null, \Sabre\BargainFinderMax\Structs\MaxOneWayOptions $maxOneWayOptions = null, \Sabre\BargainFinderMax\Structs\NumOneWayOptions $numOneWayOptions = null, \Sabre\BargainFinderMax\Structs\CabinPrefType $cabinPref = null, \Sabre\BargainFinderMax\Structs\ConnectionTime $connectionTime = null, \Sabre\BargainFinderMax\Structs\TotalTravelTime $totalTravelTime = null)
    {
        $this
            ->setFlight($flight)
            ->setDateFlexibility($dateFlexibility)
            ->setSisterDestinationLocation($sisterDestinationLocation)
            ->setSisterDestinationMileage($sisterDestinationMileage)
            ->setSisterOriginLocation($sisterOriginLocation)
            ->setSisterOriginMileage($sisterOriginMileage)
            ->setSegmentType($segmentType)
            ->setAlternateTime($alternateTime)
            ->setMaxOneWayOptions($maxOneWayOptions)
            ->setNumOneWayOptions($numOneWayOptions)
            ->setCabinPref($cabinPref)
            ->setConnectionTime($connectionTime)
            ->setTotalTravelTime($totalTravelTime);
    }
    /**
     * Get Flight value
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationFlightType[]|null
     */
    public function getFlight()
    {
        return $this->Flight;
    }
    /**
     * Set Flight value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationFlightType[] $flight
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setFlight(array $flight = array())
    {
        $this->Flight = $flight;
        return $this;
    }
    /**
     * Add item to Flight value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationFlightType $item
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function addToFlight(\Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationFlightType $item)
    {
        $this->Flight[] = $item;
        return $this;
    }
    /**
     * Get DateFlexibility value
     * @return \Sabre\BargainFinderMax\Structs\DateFlexibility|null
     */
    public function getDateFlexibility()
    {
        return $this->DateFlexibility;
    }
    /**
     * Set DateFlexibility value
     * @param \Sabre\BargainFinderMax\Structs\DateFlexibility $dateFlexibility
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setDateFlexibility(\Sabre\BargainFinderMax\Structs\DateFlexibility $dateFlexibility = null)
    {
        $this->DateFlexibility = $dateFlexibility;
        return $this;
    }
    /**
     * Get SisterDestinationLocation value
     * @return \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType|null
     */
    public function getSisterDestinationLocation()
    {
        return $this->SisterDestinationLocation;
    }
    /**
     * Set SisterDestinationLocation value
     * @param \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $sisterDestinationLocation
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setSisterDestinationLocation(\Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $sisterDestinationLocation = null)
    {
        $this->SisterDestinationLocation = $sisterDestinationLocation;
        return $this;
    }
    /**
     * Get SisterDestinationMileage value
     * @return \Sabre\BargainFinderMax\Structs\SisterDestinationMileage|null
     */
    public function getSisterDestinationMileage()
    {
        return $this->SisterDestinationMileage;
    }
    /**
     * Set SisterDestinationMileage value
     * @param \Sabre\BargainFinderMax\Structs\SisterDestinationMileage $sisterDestinationMileage
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setSisterDestinationMileage(\Sabre\BargainFinderMax\Structs\SisterDestinationMileage $sisterDestinationMileage = null)
    {
        $this->SisterDestinationMileage = $sisterDestinationMileage;
        return $this;
    }
    /**
     * Get SisterOriginLocation value
     * @return \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType|null
     */
    public function getSisterOriginLocation()
    {
        return $this->SisterOriginLocation;
    }
    /**
     * Set SisterOriginLocation value
     * @param \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $sisterOriginLocation
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setSisterOriginLocation(\Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $sisterOriginLocation = null)
    {
        $this->SisterOriginLocation = $sisterOriginLocation;
        return $this;
    }
    /**
     * Get SisterOriginMileage value
     * @return \Sabre\BargainFinderMax\Structs\SisterOriginMileage|null
     */
    public function getSisterOriginMileage()
    {
        return $this->SisterOriginMileage;
    }
    /**
     * Set SisterOriginMileage value
     * @param \Sabre\BargainFinderMax\Structs\SisterOriginMileage $sisterOriginMileage
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setSisterOriginMileage(\Sabre\BargainFinderMax\Structs\SisterOriginMileage $sisterOriginMileage = null)
    {
        $this->SisterOriginMileage = $sisterOriginMileage;
        return $this;
    }
    /**
     * Get SegmentType value
     * @return \Sabre\BargainFinderMax\Structs\SegmentType|null
     */
    public function getSegmentType()
    {
        return $this->SegmentType;
    }
    /**
     * Set SegmentType value
     * @param \Sabre\BargainFinderMax\Structs\SegmentType $segmentType
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setSegmentType(\Sabre\BargainFinderMax\Structs\SegmentType $segmentType = null)
    {
        $this->SegmentType = $segmentType;
        return $this;
    }
    /**
     * Get AlternateTime value
     * @return \Sabre\BargainFinderMax\Structs\AlternateTime|null
     */
    public function getAlternateTime()
    {
        return $this->AlternateTime;
    }
    /**
     * Set AlternateTime value
     * @param \Sabre\BargainFinderMax\Structs\AlternateTime $alternateTime
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setAlternateTime(\Sabre\BargainFinderMax\Structs\AlternateTime $alternateTime = null)
    {
        $this->AlternateTime = $alternateTime;
        return $this;
    }
    /**
     * Get MaxOneWayOptions value
     * @return \Sabre\BargainFinderMax\Structs\MaxOneWayOptions|null
     */
    public function getMaxOneWayOptions()
    {
        return $this->MaxOneWayOptions;
    }
    /**
     * Set MaxOneWayOptions value
     * @param \Sabre\BargainFinderMax\Structs\MaxOneWayOptions $maxOneWayOptions
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setMaxOneWayOptions(\Sabre\BargainFinderMax\Structs\MaxOneWayOptions $maxOneWayOptions = null)
    {
        $this->MaxOneWayOptions = $maxOneWayOptions;
        return $this;
    }
    /**
     * Get NumOneWayOptions value
     * @return \Sabre\BargainFinderMax\Structs\NumOneWayOptions|null
     */
    public function getNumOneWayOptions()
    {
        return $this->NumOneWayOptions;
    }
    /**
     * Set NumOneWayOptions value
     * @param \Sabre\BargainFinderMax\Structs\NumOneWayOptions $numOneWayOptions
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setNumOneWayOptions(\Sabre\BargainFinderMax\Structs\NumOneWayOptions $numOneWayOptions = null)
    {
        $this->NumOneWayOptions = $numOneWayOptions;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \Sabre\BargainFinderMax\Structs\CabinPrefType|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * Set CabinPref value
     * @param \Sabre\BargainFinderMax\Structs\CabinPrefType $cabinPref
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setCabinPref(\Sabre\BargainFinderMax\Structs\CabinPrefType $cabinPref = null)
    {
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Get ConnectionTime value
     * @return \Sabre\BargainFinderMax\Structs\ConnectionTime|null
     */
    public function getConnectionTime()
    {
        return $this->ConnectionTime;
    }
    /**
     * Set ConnectionTime value
     * @param \Sabre\BargainFinderMax\Structs\ConnectionTime $connectionTime
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setConnectionTime(\Sabre\BargainFinderMax\Structs\ConnectionTime $connectionTime = null)
    {
        $this->ConnectionTime = $connectionTime;
        return $this;
    }
    /**
     * Get TotalTravelTime value
     * @return \Sabre\BargainFinderMax\Structs\TotalTravelTime|null
     */
    public function getTotalTravelTime()
    {
        return $this->TotalTravelTime;
    }
    /**
     * Set TotalTravelTime value
     * @param \Sabre\BargainFinderMax\Structs\TotalTravelTime $totalTravelTime
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public function setTotalTravelTime(\Sabre\BargainFinderMax\Structs\TotalTravelTime $totalTravelTime = null)
    {
        $this->TotalTravelTime = $totalTravelTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ExchangeOriginDestinationInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
