<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquivFare Structs
 * Meta informations extracted from the WSDL
 * - documentation: Price of the inventory excluding taxes and fees in the payable currency. | Price of the inventory excluding taxes and fees in the payable currency. | Price of the inventory excluding taxes and fees in the payable currency.
 * @subpackage Structs
 */
class EquivFare extends CurrencyAmountType
{
    /**
     * The EffectivePriceDeviation
     * Meta informations extracted from the WSDL
     * - documentation: Effective Price Deviation | Effective Price Deviation | Effective Price Deviation | Used for amounts, max 3 decimals
     * - use: optional
     * - fractionDigits: 3
     * @var float
     */
    public $EffectivePriceDeviation;
    /**
     * The EffectiveDeviationType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $EffectiveDeviationType;
    /**
     * Constructor method for EquivFare
     * @uses EquivFare::setEffectivePriceDeviation()
     * @uses EquivFare::setEffectiveDeviationType()
     * @param float $effectivePriceDeviation
     * @param string $effectiveDeviationType
     */
    public function __construct($effectivePriceDeviation = null, $effectiveDeviationType = null)
    {
        $this
            ->setEffectivePriceDeviation($effectivePriceDeviation)
            ->setEffectiveDeviationType($effectiveDeviationType);
    }
    /**
     * Get EffectivePriceDeviation value
     * @return float|null
     */
    public function getEffectivePriceDeviation()
    {
        return $this->EffectivePriceDeviation;
    }
    /**
     * Set EffectivePriceDeviation value
     * @param float $effectivePriceDeviation
     * @return \Sabre\BargainFinderMax\Structs\EquivFare
     */
    public function setEffectivePriceDeviation($effectivePriceDeviation = null)
    {
        $this->EffectivePriceDeviation = $effectivePriceDeviation;
        return $this;
    }
    /**
     * Get EffectiveDeviationType value
     * @return string|null
     */
    public function getEffectiveDeviationType()
    {
        return $this->EffectiveDeviationType;
    }
    /**
     * Set EffectiveDeviationType value
     * @param string $effectiveDeviationType
     * @return \Sabre\BargainFinderMax\Structs\EquivFare
     */
    public function setEffectiveDeviationType($effectiveDeviationType = null)
    {
        $this->EffectiveDeviationType = $effectiveDeviationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\EquivFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
