<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Electronic email addresses, in IETF specified format. | Used for Character Strings, length 1 to 128
 * - maxLength: 128
 * - minLength: 1
 * @subpackage Structs
 */
class EmailType extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 128
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The EmailType
     * Meta informations extracted from the WSDL
     * - documentation: Defines the purpose of the e-mail address (e.g. personal, business, listserve). Refer to OTA Code List Email Address Type (EAT). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - use: optional
     * @var string
     */
    public $EmailType;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The DefaultInd
     * @var bool
     */
    public $DefaultInd;
    /**
     * Constructor method for EmailType
     * @uses EmailType::set_()
     * @uses EmailType::setEmailType()
     * @uses EmailType::setShareSynchInd()
     * @uses EmailType::setShareMarketInd()
     * @uses EmailType::setDefaultInd()
     * @param string $_
     * @param string $emailType
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $defaultInd
     */
    public function __construct($_ = null, $emailType = null, $shareSynchInd = null, $shareMarketInd = null, $defaultInd = null)
    {
        $this
            ->set_($_)
            ->setEmailType($emailType)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setDefaultInd($defaultInd);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\EmailType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get EmailType value
     * @return string|null
     */
    public function getEmailType()
    {
        return $this->EmailType;
    }
    /**
     * Set EmailType value
     * @param string $emailType
     * @return \Sabre\BargainFinderMax\Structs\EmailType
     */
    public function setEmailType($emailType = null)
    {
        $this->EmailType = $emailType;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \Sabre\BargainFinderMax\Structs\EmailType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \Sabre\BargainFinderMax\Structs\EmailType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \Sabre\BargainFinderMax\Structs\EmailType
     */
    public function setDefaultInd($defaultInd = null)
    {
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\EmailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
