<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Diagnostics Structs
 * Meta informations extracted from the WSDL
 * - documentation: For internal use
 * @subpackage Structs
 */
class Diagnostics extends AbstractStructBase
{
    /**
     * The Diagnostic
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\BargainFinderMax\Structs\Diagnostic[]
     */
    public $Diagnostic;
    /**
     * Constructor method for Diagnostics
     * @uses Diagnostics::setDiagnostic()
     * @param \Sabre\BargainFinderMax\Structs\Diagnostic[] $diagnostic
     */
    public function __construct(array $diagnostic = array())
    {
        $this
            ->setDiagnostic($diagnostic);
    }
    /**
     * Get Diagnostic value
     * @return \Sabre\BargainFinderMax\Structs\Diagnostic[]|null
     */
    public function getDiagnostic()
    {
        return $this->Diagnostic;
    }
    /**
     * Set Diagnostic value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Diagnostic[] $diagnostic
     * @return \Sabre\BargainFinderMax\Structs\Diagnostics
     */
    public function setDiagnostic(array $diagnostic = array())
    {
        $this->Diagnostic = $diagnostic;
        return $this;
    }
    /**
     * Add item to Diagnostic value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\Diagnostic $item
     * @return \Sabre\BargainFinderMax\Structs\Diagnostics
     */
    public function addToDiagnostic(\Sabre\BargainFinderMax\Structs\Diagnostic $item)
    {
        $this->Diagnostic[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Diagnostics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
