<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationLocation Structs
 * Meta informations extracted from the WSDL
 * - documentation: Travel Destination Location - for example, air uses the IATA 3 letter code. | Flight destination code
 * - type: RequestLocationType
 * @subpackage Structs
 */
class DestinationLocation extends RequestSpecifiedLocationType
{
    /**
     * The _
     * @var \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType
     */
    public $_;
    /**
     * The AllAirports
     * Meta informations extracted from the WSDL
     * - documentation: Flag indicating if all cached destination cities are to be processed as destination airports.
     * - use: optional
     * @var bool
     */
    public $AllAirports;
    /**
     * Constructor method for DestinationLocation
     * @uses DestinationLocation::set_()
     * @uses DestinationLocation::setAllAirports()
     * @param \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $_
     * @param bool $allAirports
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $_ = null, $allAirports = null)
    {
        $this
            ->set_($_)
            ->setAllAirports($allAirports);
    }
    /**
     * Get _ value
     * @return \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $_
     * @return \Sabre\BargainFinderMax\Structs\DestinationLocation
     */
    public function set_(\Sabre\BargainFinderMax\Structs\RequestSpecifiedLocationType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get AllAirports value
     * @return bool|null
     */
    public function getAllAirports()
    {
        return $this->AllAirports;
    }
    /**
     * Set AllAirports value
     * @param bool $allAirports
     * @return \Sabre\BargainFinderMax\Structs\DestinationLocation
     */
    public function setAllAirports($allAirports = null)
    {
        $this->AllAirports = $allAirports;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\DestinationLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
