<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DaysRange Structs
 * @subpackage Structs
 */
class DaysRange extends AbstractStructBase
{
    /**
     * The FromDate
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: IntelliSell Date type (required format: YYYY-MM-DD)
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: IntelliSell Date type (required format: YYYY-MM-DD)
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * @var string
     */
    public $ToDate;
    /**
     * The WeekDays
     * Meta informations extracted from the WSDL
     * - documentation: Value format: First letter of the name of the day or '_', eg. 'SMT___S' means we are interested in departing at Saturday, Sunday, Monday or Tuesday. Even if there are schedules for Wednesday, Thursday or Friday, they won't be
     * returned in ISell response.
     * - pattern: [S_][M_][T_][W_][T_][F_][S_]
     * @var string
     */
    public $WeekDays;
    /**
     * Constructor method for DaysRange
     * @uses DaysRange::setFromDate()
     * @uses DaysRange::setToDate()
     * @uses DaysRange::setWeekDays()
     * @param string $fromDate
     * @param string $toDate
     * @param string $weekDays
     */
    public function __construct($fromDate = null, $toDate = null, $weekDays = null)
    {
        $this
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setWeekDays($weekDays);
    }
    /**
     * Get FromDate value
     * @return string
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \Sabre\BargainFinderMax\Structs\DaysRange
     */
    public function setFromDate($fromDate = null)
    {
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \Sabre\BargainFinderMax\Structs\DaysRange
     */
    public function setToDate($toDate = null)
    {
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get WeekDays value
     * @return string|null
     */
    public function getWeekDays()
    {
        return $this->WeekDays;
    }
    /**
     * Set WeekDays value
     * @param string $weekDays
     * @return \Sabre\BargainFinderMax\Structs\DaysRange
     */
    public function setWeekDays($weekDays = null)
    {
        $this->WeekDays = $weekDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\DaysRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
