<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Day Structs
 * @subpackage Structs
 */
class Day extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: IntelliSell Date type (required format: YYYY-MM-DD)
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * @var string
     */
    public $Date;
    /**
     * Constructor method for Day
     * @uses Day::setDate()
     * @param string $date
     */
    public function __construct($date = null)
    {
        $this
            ->setDate($date);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Sabre\BargainFinderMax\Structs\Day
     */
    public function setDate($date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Day
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
