<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTimeType Structs
 * @subpackage Structs
 */
abstract class DateTimeType extends AbstractStructBase
{
    /**
     * The TimeWindowStart
     * Meta informations extracted from the WSDL
     * - documentation: Allowed amount of time before specified time. | IntelliSell Time Window Boundary type in format HHMM.
     * - pattern: ([0-1][0-9]|2[0-3])[0-5][0-9]
     * @var string
     */
    public $TimeWindowStart;
    /**
     * The TimeWindowEnd
     * Meta informations extracted from the WSDL
     * - documentation: Allowed amount of time after specified time. | IntelliSell Time Window Boundary type in format HHMM.
     * - pattern: ([0-1][0-9]|2[0-3])[0-5][0-9]
     * @var string
     */
    public $TimeWindowEnd;
    /**
     * The TimeTolerance
     * Meta informations extracted from the WSDL
     * - documentation: Maximum time difference between actual and desired time.
     * @var int
     */
    public $TimeTolerance;
    /**
     * The DateFlexibility
     * Meta informations extracted from the WSDL
     * - documentation: The number of alternate days around the travel date to search.
     * @var int
     */
    public $DateFlexibility;
    /**
     * The MaxOptionsPerDate
     * Meta informations extracted from the WSDL
     * - documentation: Number of options for requested date.
     * @var int
     */
    public $MaxOptionsPerDate;
    /**
     * The ConnectionTimeMin
     * Meta informations extracted from the WSDL
     * - documentation: Minimal amount of time between flights
     * @var int
     */
    public $ConnectionTimeMin;
    /**
     * The ConnectionTimeMax
     * Meta informations extracted from the WSDL
     * - documentation: Maximal amount of time between flights
     * @var int
     */
    public $ConnectionTimeMax;
    /**
     * Constructor method for DateTimeType
     * @uses DateTimeType::setTimeWindowStart()
     * @uses DateTimeType::setTimeWindowEnd()
     * @uses DateTimeType::setTimeTolerance()
     * @uses DateTimeType::setDateFlexibility()
     * @uses DateTimeType::setMaxOptionsPerDate()
     * @uses DateTimeType::setConnectionTimeMin()
     * @uses DateTimeType::setConnectionTimeMax()
     * @param string $timeWindowStart
     * @param string $timeWindowEnd
     * @param int $timeTolerance
     * @param int $dateFlexibility
     * @param int $maxOptionsPerDate
     * @param int $connectionTimeMin
     * @param int $connectionTimeMax
     */
    public function __construct($timeWindowStart = null, $timeWindowEnd = null, $timeTolerance = null, $dateFlexibility = null, $maxOptionsPerDate = null, $connectionTimeMin = null, $connectionTimeMax = null)
    {
        $this
            ->setTimeWindowStart($timeWindowStart)
            ->setTimeWindowEnd($timeWindowEnd)
            ->setTimeTolerance($timeTolerance)
            ->setDateFlexibility($dateFlexibility)
            ->setMaxOptionsPerDate($maxOptionsPerDate)
            ->setConnectionTimeMin($connectionTimeMin)
            ->setConnectionTimeMax($connectionTimeMax);
    }
    /**
     * Get TimeWindowStart value
     * @return string|null
     */
    public function getTimeWindowStart()
    {
        return $this->TimeWindowStart;
    }
    /**
     * Set TimeWindowStart value
     * @param string $timeWindowStart
     * @return \Sabre\BargainFinderMax\Structs\DateTimeType
     */
    public function setTimeWindowStart($timeWindowStart = null)
    {
        $this->TimeWindowStart = $timeWindowStart;
        return $this;
    }
    /**
     * Get TimeWindowEnd value
     * @return string|null
     */
    public function getTimeWindowEnd()
    {
        return $this->TimeWindowEnd;
    }
    /**
     * Set TimeWindowEnd value
     * @param string $timeWindowEnd
     * @return \Sabre\BargainFinderMax\Structs\DateTimeType
     */
    public function setTimeWindowEnd($timeWindowEnd = null)
    {
        $this->TimeWindowEnd = $timeWindowEnd;
        return $this;
    }
    /**
     * Get TimeTolerance value
     * @return int|null
     */
    public function getTimeTolerance()
    {
        return $this->TimeTolerance;
    }
    /**
     * Set TimeTolerance value
     * @param int $timeTolerance
     * @return \Sabre\BargainFinderMax\Structs\DateTimeType
     */
    public function setTimeTolerance($timeTolerance = null)
    {
        $this->TimeTolerance = $timeTolerance;
        return $this;
    }
    /**
     * Get DateFlexibility value
     * @return int|null
     */
    public function getDateFlexibility()
    {
        return $this->DateFlexibility;
    }
    /**
     * Set DateFlexibility value
     * @param int $dateFlexibility
     * @return \Sabre\BargainFinderMax\Structs\DateTimeType
     */
    public function setDateFlexibility($dateFlexibility = null)
    {
        $this->DateFlexibility = $dateFlexibility;
        return $this;
    }
    /**
     * Get MaxOptionsPerDate value
     * @return int|null
     */
    public function getMaxOptionsPerDate()
    {
        return $this->MaxOptionsPerDate;
    }
    /**
     * Set MaxOptionsPerDate value
     * @param int $maxOptionsPerDate
     * @return \Sabre\BargainFinderMax\Structs\DateTimeType
     */
    public function setMaxOptionsPerDate($maxOptionsPerDate = null)
    {
        $this->MaxOptionsPerDate = $maxOptionsPerDate;
        return $this;
    }
    /**
     * Get ConnectionTimeMin value
     * @return int|null
     */
    public function getConnectionTimeMin()
    {
        return $this->ConnectionTimeMin;
    }
    /**
     * Set ConnectionTimeMin value
     * @param int $connectionTimeMin
     * @return \Sabre\BargainFinderMax\Structs\DateTimeType
     */
    public function setConnectionTimeMin($connectionTimeMin = null)
    {
        $this->ConnectionTimeMin = $connectionTimeMin;
        return $this;
    }
    /**
     * Get ConnectionTimeMax value
     * @return int|null
     */
    public function getConnectionTimeMax()
    {
        return $this->ConnectionTimeMax;
    }
    /**
     * Set ConnectionTimeMax value
     * @param int $connectionTimeMax
     * @return \Sabre\BargainFinderMax\Structs\DateTimeType
     */
    public function setConnectionTimeMax($connectionTimeMax = null)
    {
        $this->ConnectionTimeMax = $connectionTimeMax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\DateTimeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
