<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Currency Structs
 * @subpackage Structs
 */
class Currency extends AbstractStructBase
{
    /**
     * The Dual
     * Meta informations extracted from the WSDL
     * - documentation: Dual currency | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - use: optional
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $Dual;
    /**
     * The MOverride
     * Meta informations extracted from the WSDL
     * - documentation: M override
     * - use: optional
     * @var bool
     */
    public $MOverride;
    /**
     * Constructor method for Currency
     * @uses Currency::setDual()
     * @uses Currency::setMOverride()
     * @param string $dual
     * @param bool $mOverride
     */
    public function __construct($dual = null, $mOverride = null)
    {
        $this
            ->setDual($dual)
            ->setMOverride($mOverride);
    }
    /**
     * Get Dual value
     * @return string|null
     */
    public function getDual()
    {
        return $this->Dual;
    }
    /**
     * Set Dual value
     * @param string $dual
     * @return \Sabre\BargainFinderMax\Structs\Currency
     */
    public function setDual($dual = null)
    {
        $this->Dual = $dual;
        return $this;
    }
    /**
     * Get MOverride value
     * @return bool|null
     */
    public function getMOverride()
    {
        return $this->MOverride;
    }
    /**
     * Set MOverride value
     * @param bool $mOverride
     * @return \Sabre\BargainFinderMax\Structs\Currency
     */
    public function setMOverride($mOverride = null)
    {
        $this->MOverride = $mOverride;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Currency
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
