<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountryNameType Structs
 * Meta informations extracted from the WSDL
 * - documentation: The name or code of a country (e.g. as used in an address or to specify citizenship of a traveller). | Used for Character Strings, length 0 to 64
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class CountryNameType extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 64
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: ISO 3166 code for a country. | 2 character country code as defined in ISO3166.
     * - use: optional
     * - pattern: [a-zA-Z]{2}
     * @var string
     */
    public $Code;
    /**
     * Constructor method for CountryNameType
     * @uses CountryNameType::set_()
     * @uses CountryNameType::setCode()
     * @param string $_
     * @param string $code
     */
    public function __construct($_ = null, $code = null)
    {
        $this
            ->set_($_)
            ->setCode($code);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\BargainFinderMax\Structs\CountryNameType
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\CountryNameType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\CountryNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
