<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Conversion Structs
 * @subpackage Structs
 */
class Conversion extends AbstractStructBase
{
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $From;
    /**
     * The To
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $To;
    /**
     * The RateOfExchange
     * Meta informations extracted from the WSDL
     * - documentation: Exchange rate
     * @var float
     */
    public $RateOfExchange;
    /**
     * Constructor method for Conversion
     * @uses Conversion::setFrom()
     * @uses Conversion::setTo()
     * @uses Conversion::setRateOfExchange()
     * @param string $from
     * @param string $to
     * @param float $rateOfExchange
     */
    public function __construct($from = null, $to = null, $rateOfExchange = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setRateOfExchange($rateOfExchange);
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \Sabre\BargainFinderMax\Structs\Conversion
     */
    public function setFrom($from = null)
    {
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \Sabre\BargainFinderMax\Structs\Conversion
     */
    public function setTo($to = null)
    {
        $this->To = $to;
        return $this;
    }
    /**
     * Get RateOfExchange value
     * @return float|null
     */
    public function getRateOfExchange()
    {
        return $this->RateOfExchange;
    }
    /**
     * Set RateOfExchange value
     * @param float $rateOfExchange
     * @return \Sabre\BargainFinderMax\Structs\Conversion
     */
    public function setRateOfExchange($rateOfExchange = null)
    {
        $this->RateOfExchange = $rateOfExchange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Conversion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
