<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyNamePrefType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Identifies a preferred company by name.
 * @subpackage Structs
 */
class CompanyNamePrefType extends CompanyNameType
{
    /**
     * The _
     * @var \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public $_;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Specifies what type of carrier it applies to.
     * @var string
     */
    public $Type;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for CompanyNamePrefType
     * @uses CompanyNamePrefType::set_()
     * @uses CompanyNamePrefType::setType()
     * @uses CompanyNamePrefType::setPreferLevel()
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $_
     * @param string $type
     * @param string $preferLevel
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\CompanyNameType $_ = null, $type = null, $preferLevel = null)
    {
        $this
            ->set_($_)
            ->setType($type)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $_
     * @return \Sabre\BargainFinderMax\Structs\CompanyNamePrefType
     */
    public function set_(\Sabre\BargainFinderMax\Structs\CompanyNameType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Sabre\BargainFinderMax\Enums\CarrierType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\CarrierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\CompanyNamePrefType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \Sabre\BargainFinderMax\Structs\CompanyNamePrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\CompanyNamePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
