<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionData Structs
 * @subpackage Structs
 */
class CommissionData extends AbstractStructBase
{
    /**
     * The VCCInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 23
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\VCCInformationType[]
     */
    public $VCCInformation;
    /**
     * The Cat35CommissionPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Cat 35 Commission Percentage
     * - use: optional
     * @var float
     */
    public $Cat35CommissionPercentage;
    /**
     * The Cat35CommissionAmount
     * Meta informations extracted from the WSDL
     * - documentation: Cat 35 Commission Amount
     * - use: optional
     * @var float
     */
    public $Cat35CommissionAmount;
    /**
     * The Cat35MarkupAmount
     * Meta informations extracted from the WSDL
     * - documentation: Cat 35 Markup Amount in equivalent amount currency
     * - use: optional
     * @var float
     */
    public $Cat35MarkupAmount;
    /**
     * The CommissionAmountInEquivalent
     * Meta informations extracted from the WSDL
     * - documentation: Commission Amount in equivalent amount currency
     * - use: optional
     * @var float
     */
    public $CommissionAmountInEquivalent;
    /**
     * The CommissionSource
     * Meta informations extracted from the WSDL
     * - documentation: Commission Source [value C for Cat 35, A for AMC, M for Manual] | Used for Characters, length 1 | Used for Characters, length 1
     * - use: optional
     * - length: 1
     * @var string
     */
    public $CommissionSource;
    /**
     * Constructor method for CommissionData
     * @uses CommissionData::setVCCInformation()
     * @uses CommissionData::setCat35CommissionPercentage()
     * @uses CommissionData::setCat35CommissionAmount()
     * @uses CommissionData::setCat35MarkupAmount()
     * @uses CommissionData::setCommissionAmountInEquivalent()
     * @uses CommissionData::setCommissionSource()
     * @param \Sabre\BargainFinderMax\Structs\VCCInformationType[] $vCCInformation
     * @param float $cat35CommissionPercentage
     * @param float $cat35CommissionAmount
     * @param float $cat35MarkupAmount
     * @param float $commissionAmountInEquivalent
     * @param string $commissionSource
     */
    public function __construct(array $vCCInformation = array(), $cat35CommissionPercentage = null, $cat35CommissionAmount = null, $cat35MarkupAmount = null, $commissionAmountInEquivalent = null, $commissionSource = null)
    {
        $this
            ->setVCCInformation($vCCInformation)
            ->setCat35CommissionPercentage($cat35CommissionPercentage)
            ->setCat35CommissionAmount($cat35CommissionAmount)
            ->setCat35MarkupAmount($cat35MarkupAmount)
            ->setCommissionAmountInEquivalent($commissionAmountInEquivalent)
            ->setCommissionSource($commissionSource);
    }
    /**
     * Get VCCInformation value
     * @return \Sabre\BargainFinderMax\Structs\VCCInformationType[]|null
     */
    public function getVCCInformation()
    {
        return $this->VCCInformation;
    }
    /**
     * Set VCCInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\VCCInformationType[] $vCCInformation
     * @return \Sabre\BargainFinderMax\Structs\CommissionData
     */
    public function setVCCInformation(array $vCCInformation = array())
    {
        $this->VCCInformation = $vCCInformation;
        return $this;
    }
    /**
     * Add item to VCCInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\VCCInformationType $item
     * @return \Sabre\BargainFinderMax\Structs\CommissionData
     */
    public function addToVCCInformation(\Sabre\BargainFinderMax\Structs\VCCInformationType $item)
    {
        $this->VCCInformation[] = $item;
        return $this;
    }
    /**
     * Get Cat35CommissionPercentage value
     * @return float|null
     */
    public function getCat35CommissionPercentage()
    {
        return $this->Cat35CommissionPercentage;
    }
    /**
     * Set Cat35CommissionPercentage value
     * @param float $cat35CommissionPercentage
     * @return \Sabre\BargainFinderMax\Structs\CommissionData
     */
    public function setCat35CommissionPercentage($cat35CommissionPercentage = null)
    {
        $this->Cat35CommissionPercentage = $cat35CommissionPercentage;
        return $this;
    }
    /**
     * Get Cat35CommissionAmount value
     * @return float|null
     */
    public function getCat35CommissionAmount()
    {
        return $this->Cat35CommissionAmount;
    }
    /**
     * Set Cat35CommissionAmount value
     * @param float $cat35CommissionAmount
     * @return \Sabre\BargainFinderMax\Structs\CommissionData
     */
    public function setCat35CommissionAmount($cat35CommissionAmount = null)
    {
        $this->Cat35CommissionAmount = $cat35CommissionAmount;
        return $this;
    }
    /**
     * Get Cat35MarkupAmount value
     * @return float|null
     */
    public function getCat35MarkupAmount()
    {
        return $this->Cat35MarkupAmount;
    }
    /**
     * Set Cat35MarkupAmount value
     * @param float $cat35MarkupAmount
     * @return \Sabre\BargainFinderMax\Structs\CommissionData
     */
    public function setCat35MarkupAmount($cat35MarkupAmount = null)
    {
        $this->Cat35MarkupAmount = $cat35MarkupAmount;
        return $this;
    }
    /**
     * Get CommissionAmountInEquivalent value
     * @return float|null
     */
    public function getCommissionAmountInEquivalent()
    {
        return $this->CommissionAmountInEquivalent;
    }
    /**
     * Set CommissionAmountInEquivalent value
     * @param float $commissionAmountInEquivalent
     * @return \Sabre\BargainFinderMax\Structs\CommissionData
     */
    public function setCommissionAmountInEquivalent($commissionAmountInEquivalent = null)
    {
        $this->CommissionAmountInEquivalent = $commissionAmountInEquivalent;
        return $this;
    }
    /**
     * Get CommissionSource value
     * @return string|null
     */
    public function getCommissionSource()
    {
        return $this->CommissionSource;
    }
    /**
     * Set CommissionSource value
     * @param string $commissionSource
     * @return \Sabre\BargainFinderMax\Structs\CommissionData
     */
    public function setCommissionSource($commissionSource = null)
    {
        $this->CommissionSource = $commissionSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\CommissionData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
