<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeFee Structs
 * @subpackage Structs
 */
class ChangeFee extends AbstractStructBase
{
    /**
     * The HighestChangeFee
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $HighestChangeFee;
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Used for amounts, max 3 decimals
     * - fractionDigits: 3
     * @var float
     */
    public $PaymentAmount;
    /**
     * The PaymentCurrency
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $PaymentCurrency;
    /**
     * The PaymentDecimalPlaces
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $PaymentDecimalPlaces;
    /**
     * The ChangeFeeWaived
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ChangeFeeWaived;
    /**
     * The ChangeFeeNotApplicable
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ChangeFeeNotApplicable;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: Used for Currency Codes | Used for Currency Codes | Used for Alphabetic Strings, length exactly 3 | Used for Alphabetic Strings, length exactly 3
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for ChangeFee
     * @uses ChangeFee::setHighestChangeFee()
     * @uses ChangeFee::setPaymentAmount()
     * @uses ChangeFee::setPaymentCurrency()
     * @uses ChangeFee::setPaymentDecimalPlaces()
     * @uses ChangeFee::setChangeFeeWaived()
     * @uses ChangeFee::setChangeFeeNotApplicable()
     * @uses ChangeFee::setAmount()
     * @uses ChangeFee::setCurrencyCode()
     * @uses ChangeFee::setDecimalPlaces()
     * @param bool $highestChangeFee
     * @param float $paymentAmount
     * @param string $paymentCurrency
     * @param int $paymentDecimalPlaces
     * @param bool $changeFeeWaived
     * @param bool $changeFeeNotApplicable
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($highestChangeFee = null, $paymentAmount = null, $paymentCurrency = null, $paymentDecimalPlaces = null, $changeFeeWaived = null, $changeFeeNotApplicable = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setHighestChangeFee($highestChangeFee)
            ->setPaymentAmount($paymentAmount)
            ->setPaymentCurrency($paymentCurrency)
            ->setPaymentDecimalPlaces($paymentDecimalPlaces)
            ->setChangeFeeWaived($changeFeeWaived)
            ->setChangeFeeNotApplicable($changeFeeNotApplicable)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get HighestChangeFee value
     * @return bool|null
     */
    public function getHighestChangeFee()
    {
        return $this->HighestChangeFee;
    }
    /**
     * Set HighestChangeFee value
     * @param bool $highestChangeFee
     * @return \Sabre\BargainFinderMax\Structs\ChangeFee
     */
    public function setHighestChangeFee($highestChangeFee = null)
    {
        $this->HighestChangeFee = $highestChangeFee;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \Sabre\BargainFinderMax\Structs\ChangeFee
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get PaymentCurrency value
     * @return string|null
     */
    public function getPaymentCurrency()
    {
        return $this->PaymentCurrency;
    }
    /**
     * Set PaymentCurrency value
     * @param string $paymentCurrency
     * @return \Sabre\BargainFinderMax\Structs\ChangeFee
     */
    public function setPaymentCurrency($paymentCurrency = null)
    {
        $this->PaymentCurrency = $paymentCurrency;
        return $this;
    }
    /**
     * Get PaymentDecimalPlaces value
     * @return int|null
     */
    public function getPaymentDecimalPlaces()
    {
        return $this->PaymentDecimalPlaces;
    }
    /**
     * Set PaymentDecimalPlaces value
     * @param int $paymentDecimalPlaces
     * @return \Sabre\BargainFinderMax\Structs\ChangeFee
     */
    public function setPaymentDecimalPlaces($paymentDecimalPlaces = null)
    {
        $this->PaymentDecimalPlaces = $paymentDecimalPlaces;
        return $this;
    }
    /**
     * Get ChangeFeeWaived value
     * @return bool|null
     */
    public function getChangeFeeWaived()
    {
        return $this->ChangeFeeWaived;
    }
    /**
     * Set ChangeFeeWaived value
     * @param bool $changeFeeWaived
     * @return \Sabre\BargainFinderMax\Structs\ChangeFee
     */
    public function setChangeFeeWaived($changeFeeWaived = null)
    {
        $this->ChangeFeeWaived = $changeFeeWaived;
        return $this;
    }
    /**
     * Get ChangeFeeNotApplicable value
     * @return bool|null
     */
    public function getChangeFeeNotApplicable()
    {
        return $this->ChangeFeeNotApplicable;
    }
    /**
     * Set ChangeFeeNotApplicable value
     * @param bool $changeFeeNotApplicable
     * @return \Sabre\BargainFinderMax\Structs\ChangeFee
     */
    public function setChangeFeeNotApplicable($changeFeeNotApplicable = null)
    {
        $this->ChangeFeeNotApplicable = $changeFeeNotApplicable;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\BargainFinderMax\Structs\ChangeFee
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\BargainFinderMax\Structs\ChangeFee
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \Sabre\BargainFinderMax\Structs\ChangeFee
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ChangeFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
