<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinPrefType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Indicates preferences for choice of airline cabin for a given travel situation.
 * @subpackage Structs
 */
class CabinPrefType extends AbstractStructBase
{
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - documentation: Specify cabin type.
     * @var string
     */
    public $Cabin;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for CabinPrefType
     * @uses CabinPrefType::setCabin()
     * @uses CabinPrefType::setPreferLevel()
     * @param string $cabin
     * @param string $preferLevel
     */
    public function __construct($cabin = null, $preferLevel = null)
    {
        $this
            ->setCabin($cabin)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @uses \Sabre\BargainFinderMax\Enums\CabinType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabin
     * @return \Sabre\BargainFinderMax\Structs\CabinPrefType
     */
    public function setCabin($cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \Sabre\BargainFinderMax\Structs\CabinPrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\CabinPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
