<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cabin Structs
 * Meta informations extracted from the WSDL
 * - documentation: Defines preferred cabin to be used in a search for this leg level. | This element specifies preffered cabin type.
 * @subpackage Structs
 */
class Cabin extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Specifies cabin type.
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The PreferenceLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferenceLevel;
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - default: Economy
     * @var string
     */
    public $Cabin;
    /**
     * Constructor method for Cabin
     * @uses Cabin::setType()
     * @uses Cabin::setPreferenceLevel()
     * @uses Cabin::setCabin()
     * @param string $type
     * @param string $preferenceLevel
     * @param string $cabin
     */
    public function __construct($type = null, $preferenceLevel = 'Preferred', $cabin = 'Economy')
    {
        $this
            ->setType($type)
            ->setPreferenceLevel($preferenceLevel)
            ->setCabin($cabin);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Sabre\BargainFinderMax\Enums\CabinType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Sabre\BargainFinderMax\Structs\Cabin
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PreferenceLevel value
     * @return string|null
     */
    public function getPreferenceLevel()
    {
        return $this->PreferenceLevel;
    }
    /**
     * Set PreferenceLevel value
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferenceLevel
     * @return \Sabre\BargainFinderMax\Structs\Cabin
     */
    public function setPreferenceLevel($preferenceLevel = 'Preferred')
    {
        $this->PreferenceLevel = $preferenceLevel;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \Sabre\BargainFinderMax\Structs\Cabin
     */
    public function setCabin($cabin = 'Economy')
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\Cabin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
