<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookFlightSegmentType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Container for the flight segment data plus the MarriageGrp.
 * @subpackage Structs
 */
class BookFlightSegmentType extends AbstractStructBase
{
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - documentation: Departure point of flight segment.
     * @var \Sabre\BargainFinderMax\Structs\AirportInformationType
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - documentation: Arrival point of flight segment.
     * @var \Sabre\BargainFinderMax\Structs\AirportInformationType
     */
    public $ArrivalAirport;
    /**
     * The OperatingAirline
     * Meta informations extracted from the WSDL
     * - documentation: The operating airline of the flight if it is a codeshare flight.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OperatingAirlineType
     */
    public $OperatingAirline;
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - documentation: The type of equipment used for the flight..
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\EquipmentType[]
     */
    public $Equipment;
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - documentation: The marketing airline. This is required for use with scheduled airline messages but may be omitted for requests by tour operators.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public $MarketingAirline;
    /**
     * The DisclosureAirline
     * Meta informations extracted from the WSDL
     * - documentation: The disclosure airline. This is required by the DOT mandate.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CompanyNameType
     */
    public $DisclosureAirline;
    /**
     * The MarriageGrp
     * Meta informations extracted from the WSDL
     * - documentation: Many airlines link connection flights together by terming them married segments. When two or more segments are married, they must be processed as one unit. The segments must be moved, cancelled, and/or priced together. The value of
     * the marriage group must be the same for all segments. | Used for Character Strings, length 1 to 16
     * - minOccurs: 0
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $MarriageGrp;
    /**
     * The StopAirports
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\StopAirports
     */
    public $StopAirports;
    /**
     * The DepartureTimeZone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\DepartureTimeZone
     */
    public $DepartureTimeZone;
    /**
     * The ArrivalTimeZone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ArrivalTimeZone
     */
    public $ArrivalTimeZone;
    /**
     * The OnTimePerformance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\OnTimePerformance
     */
    public $OnTimePerformance;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The StopQuantity
     * Meta informations extracted from the WSDL
     * - documentation: The number of stops the flight makes
     * - use: optional
     * @var int
     */
    public $StopQuantity;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: (Reference Place Holder) - an index code to identify an instance in a collection of like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $RPH;
    /**
     * The InfoSource
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Used for Character Strings, length 1 to 32
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $InfoSource;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: The flight number of the flight. This is required for use with scheduled airline messages but may be omitted for requests by tour operators. | Identifies a flight number (1 to 4 numbers followed by optional uppercase A - Z, which
     * specifies an operational suffix) or OPEN or ARNK.
     * - use: optional
     * - pattern: [0-9]{1,4}[A-Z]?
     * @var string
     */
    public $FlightNumber;
    /**
     * The TourOperatorFlightID
     * Meta informations extracted from the WSDL
     * - documentation: ID of a flight in the Tour Operator's inventory. This flight is not necessarily in the inventory of an airline. Rather, it is a code created by tour operators. | Used for Character Strings, length 1 to 8
     * - use: optional
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $TourOperatorFlightID;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - documentation: Specific Booking Class for this segment. | Used for an Alpha String, length 2 (for letter codes)
     * - use: optional
     * - pattern: [A-Z\s]{1,2}
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The ActionCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ActionCode;
    /**
     * The NumberInParty
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $NumberInParty;
    /**
     * The ElapsedTime
     * Meta informations extracted from the WSDL
     * - documentation: Elapsed segment trip time.
     * @var int
     */
    public $ElapsedTime;
    /**
     * Constructor method for BookFlightSegmentType
     * @uses BookFlightSegmentType::setDepartureDateTime()
     * @uses BookFlightSegmentType::setDepartureAirport()
     * @uses BookFlightSegmentType::setArrivalAirport()
     * @uses BookFlightSegmentType::setOperatingAirline()
     * @uses BookFlightSegmentType::setEquipment()
     * @uses BookFlightSegmentType::setMarketingAirline()
     * @uses BookFlightSegmentType::setDisclosureAirline()
     * @uses BookFlightSegmentType::setMarriageGrp()
     * @uses BookFlightSegmentType::setStopAirports()
     * @uses BookFlightSegmentType::setDepartureTimeZone()
     * @uses BookFlightSegmentType::setArrivalTimeZone()
     * @uses BookFlightSegmentType::setOnTimePerformance()
     * @uses BookFlightSegmentType::setTPA_Extensions()
     * @uses BookFlightSegmentType::setArrivalDateTime()
     * @uses BookFlightSegmentType::setStopQuantity()
     * @uses BookFlightSegmentType::setRPH()
     * @uses BookFlightSegmentType::setInfoSource()
     * @uses BookFlightSegmentType::setFlightNumber()
     * @uses BookFlightSegmentType::setTourOperatorFlightID()
     * @uses BookFlightSegmentType::setResBookDesigCode()
     * @uses BookFlightSegmentType::setActionCode()
     * @uses BookFlightSegmentType::setNumberInParty()
     * @uses BookFlightSegmentType::setElapsedTime()
     * @param string $departureDateTime
     * @param \Sabre\BargainFinderMax\Structs\AirportInformationType $departureAirport
     * @param \Sabre\BargainFinderMax\Structs\AirportInformationType $arrivalAirport
     * @param \Sabre\BargainFinderMax\Structs\OperatingAirlineType $operatingAirline
     * @param \Sabre\BargainFinderMax\Structs\EquipmentType[] $equipment
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $marketingAirline
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $disclosureAirline
     * @param string $marriageGrp
     * @param \Sabre\BargainFinderMax\Structs\StopAirports $stopAirports
     * @param \Sabre\BargainFinderMax\Structs\DepartureTimeZone $departureTimeZone
     * @param \Sabre\BargainFinderMax\Structs\ArrivalTimeZone $arrivalTimeZone
     * @param \Sabre\BargainFinderMax\Structs\OnTimePerformance $onTimePerformance
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param string $arrivalDateTime
     * @param int $stopQuantity
     * @param string $rPH
     * @param string $infoSource
     * @param string $flightNumber
     * @param string $tourOperatorFlightID
     * @param string $resBookDesigCode
     * @param string $actionCode
     * @param int $numberInParty
     * @param int $elapsedTime
     */
    public function __construct($departureDateTime = null, \Sabre\BargainFinderMax\Structs\AirportInformationType $departureAirport = null, \Sabre\BargainFinderMax\Structs\AirportInformationType $arrivalAirport = null, \Sabre\BargainFinderMax\Structs\OperatingAirlineType $operatingAirline = null, array $equipment = array(), \Sabre\BargainFinderMax\Structs\CompanyNameType $marketingAirline = null, \Sabre\BargainFinderMax\Structs\CompanyNameType $disclosureAirline = null, $marriageGrp = null, \Sabre\BargainFinderMax\Structs\StopAirports $stopAirports = null, \Sabre\BargainFinderMax\Structs\DepartureTimeZone $departureTimeZone = null, \Sabre\BargainFinderMax\Structs\ArrivalTimeZone $arrivalTimeZone = null, \Sabre\BargainFinderMax\Structs\OnTimePerformance $onTimePerformance = null, \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, $arrivalDateTime = null, $stopQuantity = null, $rPH = null, $infoSource = null, $flightNumber = null, $tourOperatorFlightID = null, $resBookDesigCode = null, $actionCode = null, $numberInParty = null, $elapsedTime = null)
    {
        $this
            ->setDepartureDateTime($departureDateTime)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setOperatingAirline($operatingAirline)
            ->setEquipment($equipment)
            ->setMarketingAirline($marketingAirline)
            ->setDisclosureAirline($disclosureAirline)
            ->setMarriageGrp($marriageGrp)
            ->setStopAirports($stopAirports)
            ->setDepartureTimeZone($departureTimeZone)
            ->setArrivalTimeZone($arrivalTimeZone)
            ->setOnTimePerformance($onTimePerformance)
            ->setTPA_Extensions($tPA_Extensions)
            ->setArrivalDateTime($arrivalDateTime)
            ->setStopQuantity($stopQuantity)
            ->setRPH($rPH)
            ->setInfoSource($infoSource)
            ->setFlightNumber($flightNumber)
            ->setTourOperatorFlightID($tourOperatorFlightID)
            ->setResBookDesigCode($resBookDesigCode)
            ->setActionCode($actionCode)
            ->setNumberInParty($numberInParty)
            ->setElapsedTime($elapsedTime);
    }
    /**
     * Get DepartureDateTime value
     * @return string
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \Sabre\BargainFinderMax\Structs\AirportInformationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \Sabre\BargainFinderMax\Structs\AirportInformationType $departureAirport
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setDepartureAirport(\Sabre\BargainFinderMax\Structs\AirportInformationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \Sabre\BargainFinderMax\Structs\AirportInformationType|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \Sabre\BargainFinderMax\Structs\AirportInformationType $arrivalAirport
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setArrivalAirport(\Sabre\BargainFinderMax\Structs\AirportInformationType $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return \Sabre\BargainFinderMax\Structs\OperatingAirlineType|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @param \Sabre\BargainFinderMax\Structs\OperatingAirlineType $operatingAirline
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setOperatingAirline(\Sabre\BargainFinderMax\Structs\OperatingAirlineType $operatingAirline = null)
    {
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \Sabre\BargainFinderMax\Structs\EquipmentType[]|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\EquipmentType[] $equipment
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setEquipment(array $equipment = array())
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Add item to Equipment value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\EquipmentType $item
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function addToEquipment(\Sabre\BargainFinderMax\Structs\EquipmentType $item)
    {
        $this->Equipment[] = $item;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $marketingAirline
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setMarketingAirline(\Sabre\BargainFinderMax\Structs\CompanyNameType $marketingAirline = null)
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Get DisclosureAirline value
     * @return \Sabre\BargainFinderMax\Structs\CompanyNameType|null
     */
    public function getDisclosureAirline()
    {
        return $this->DisclosureAirline;
    }
    /**
     * Set DisclosureAirline value
     * @param \Sabre\BargainFinderMax\Structs\CompanyNameType $disclosureAirline
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setDisclosureAirline(\Sabre\BargainFinderMax\Structs\CompanyNameType $disclosureAirline = null)
    {
        $this->DisclosureAirline = $disclosureAirline;
        return $this;
    }
    /**
     * Get MarriageGrp value
     * @return string|null
     */
    public function getMarriageGrp()
    {
        return $this->MarriageGrp;
    }
    /**
     * Set MarriageGrp value
     * @param string $marriageGrp
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setMarriageGrp($marriageGrp = null)
    {
        $this->MarriageGrp = $marriageGrp;
        return $this;
    }
    /**
     * Get StopAirports value
     * @return \Sabre\BargainFinderMax\Structs\StopAirports|null
     */
    public function getStopAirports()
    {
        return $this->StopAirports;
    }
    /**
     * Set StopAirports value
     * @param \Sabre\BargainFinderMax\Structs\StopAirports $stopAirports
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setStopAirports(\Sabre\BargainFinderMax\Structs\StopAirports $stopAirports = null)
    {
        $this->StopAirports = $stopAirports;
        return $this;
    }
    /**
     * Get DepartureTimeZone value
     * @return \Sabre\BargainFinderMax\Structs\DepartureTimeZone|null
     */
    public function getDepartureTimeZone()
    {
        return $this->DepartureTimeZone;
    }
    /**
     * Set DepartureTimeZone value
     * @param \Sabre\BargainFinderMax\Structs\DepartureTimeZone $departureTimeZone
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setDepartureTimeZone(\Sabre\BargainFinderMax\Structs\DepartureTimeZone $departureTimeZone = null)
    {
        $this->DepartureTimeZone = $departureTimeZone;
        return $this;
    }
    /**
     * Get ArrivalTimeZone value
     * @return \Sabre\BargainFinderMax\Structs\ArrivalTimeZone|null
     */
    public function getArrivalTimeZone()
    {
        return $this->ArrivalTimeZone;
    }
    /**
     * Set ArrivalTimeZone value
     * @param \Sabre\BargainFinderMax\Structs\ArrivalTimeZone $arrivalTimeZone
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setArrivalTimeZone(\Sabre\BargainFinderMax\Structs\ArrivalTimeZone $arrivalTimeZone = null)
    {
        $this->ArrivalTimeZone = $arrivalTimeZone;
        return $this;
    }
    /**
     * Get OnTimePerformance value
     * @return \Sabre\BargainFinderMax\Structs\OnTimePerformance|null
     */
    public function getOnTimePerformance()
    {
        return $this->OnTimePerformance;
    }
    /**
     * Set OnTimePerformance value
     * @param \Sabre\BargainFinderMax\Structs\OnTimePerformance $onTimePerformance
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setOnTimePerformance(\Sabre\BargainFinderMax\Structs\OnTimePerformance $onTimePerformance = null)
    {
        $this->OnTimePerformance = $onTimePerformance;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get StopQuantity value
     * @return int|null
     */
    public function getStopQuantity()
    {
        return $this->StopQuantity;
    }
    /**
     * Set StopQuantity value
     * @param int $stopQuantity
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setStopQuantity($stopQuantity = null)
    {
        $this->StopQuantity = $stopQuantity;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setInfoSource($infoSource = null)
    {
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get TourOperatorFlightID value
     * @return string|null
     */
    public function getTourOperatorFlightID()
    {
        return $this->TourOperatorFlightID;
    }
    /**
     * Set TourOperatorFlightID value
     * @param string $tourOperatorFlightID
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setTourOperatorFlightID($tourOperatorFlightID = null)
    {
        $this->TourOperatorFlightID = $tourOperatorFlightID;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return string|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @uses \Sabre\BargainFinderMax\Enums\ActionCodeType::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\ActionCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionCode
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setActionCode($actionCode = null)
    {
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return int|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param int $numberInParty
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get ElapsedTime value
     * @return int|null
     */
    public function getElapsedTime()
    {
        return $this->ElapsedTime;
    }
    /**
     * Set ElapsedTime value
     * @param int $elapsedTime
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public function setElapsedTime($elapsedTime = null)
    {
        $this->ElapsedTime = $elapsedTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BookFlightSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
