<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageAllowanceType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Baggage Allowance type
 * @subpackage Structs
 */
class BaggageAllowanceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Baggage Allowance ID
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The Pieces
     * Meta informations extracted from the WSDL
     * - documentation: Number of allowed baggage pieces
     * - use: optional
     * @var int
     */
    public $Pieces;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - documentation: Allowed baggage weight
     * - use: optional
     * @var int
     */
    public $Weight;
    /**
     * The Unit
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Unit;
    /**
     * The Description1
     * Meta informations extracted from the WSDL
     * - documentation: Description 1 Text (D01)
     * - use: optional
     * @var string
     */
    public $Description1;
    /**
     * The Description2
     * Meta informations extracted from the WSDL
     * - documentation: Description 2 Text (D02)
     * - use: optional
     * @var string
     */
    public $Description2;
    /**
     * Constructor method for BaggageAllowanceType
     * @uses BaggageAllowanceType::setID()
     * @uses BaggageAllowanceType::setPieces()
     * @uses BaggageAllowanceType::setWeight()
     * @uses BaggageAllowanceType::setUnit()
     * @uses BaggageAllowanceType::setDescription1()
     * @uses BaggageAllowanceType::setDescription2()
     * @param int $iD
     * @param int $pieces
     * @param int $weight
     * @param string $unit
     * @param string $description1
     * @param string $description2
     */
    public function __construct($iD = null, $pieces = null, $weight = null, $unit = null, $description1 = null, $description2 = null)
    {
        $this
            ->setID($iD)
            ->setPieces($pieces)
            ->setWeight($weight)
            ->setUnit($unit)
            ->setDescription1($description1)
            ->setDescription2($description2);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sabre\BargainFinderMax\Structs\BaggageAllowanceType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Pieces value
     * @return int|null
     */
    public function getPieces()
    {
        return $this->Pieces;
    }
    /**
     * Set Pieces value
     * @param int $pieces
     * @return \Sabre\BargainFinderMax\Structs\BaggageAllowanceType
     */
    public function setPieces($pieces = null)
    {
        $this->Pieces = $pieces;
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \Sabre\BargainFinderMax\Structs\BaggageAllowanceType
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param string $unit
     * @return \Sabre\BargainFinderMax\Structs\BaggageAllowanceType
     */
    public function setUnit($unit = null)
    {
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Get Description1 value
     * @return string|null
     */
    public function getDescription1()
    {
        return $this->Description1;
    }
    /**
     * Set Description1 value
     * @param string $description1
     * @return \Sabre\BargainFinderMax\Structs\BaggageAllowanceType
     */
    public function setDescription1($description1 = null)
    {
        $this->Description1 = $description1;
        return $this;
    }
    /**
     * Get Description2 value
     * @return string|null
     */
    public function getDescription2()
    {
        return $this->Description2;
    }
    /**
     * Set Description2 value
     * @param string $description2
     * @return \Sabre\BargainFinderMax\Structs\BaggageAllowanceType
     */
    public function setDescription2($description2 = null)
    {
        $this->Description2 = $description2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\BaggageAllowanceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
