<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArunkType Structs
 * @subpackage Structs
 */
class ArunkType extends AbstractStructBase
{
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - documentation: Origin code
     * @var \Sabre\BargainFinderMax\Structs\RequestLocationType
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - documentation: Destination code
     * @var \Sabre\BargainFinderMax\Structs\RequestLocationType
     */
    public $DestinationLocation;
    /**
     * The SideTrip
     * Meta informations extracted from the WSDL
     * - documentation: Side trip information
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\SideTripType
     */
    public $SideTrip;
    /**
     * Constructor method for ArunkType
     * @uses ArunkType::setOriginLocation()
     * @uses ArunkType::setDestinationLocation()
     * @uses ArunkType::setSideTrip()
     * @param \Sabre\BargainFinderMax\Structs\RequestLocationType $originLocation
     * @param \Sabre\BargainFinderMax\Structs\RequestLocationType $destinationLocation
     * @param \Sabre\BargainFinderMax\Structs\SideTripType $sideTrip
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\RequestLocationType $originLocation = null, \Sabre\BargainFinderMax\Structs\RequestLocationType $destinationLocation = null, \Sabre\BargainFinderMax\Structs\SideTripType $sideTrip = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setSideTrip($sideTrip);
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\BargainFinderMax\Structs\RequestLocationType|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\BargainFinderMax\Structs\RequestLocationType $originLocation
     * @return \Sabre\BargainFinderMax\Structs\ArunkType
     */
    public function setOriginLocation(\Sabre\BargainFinderMax\Structs\RequestLocationType $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\BargainFinderMax\Structs\RequestLocationType|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\BargainFinderMax\Structs\RequestLocationType $destinationLocation
     * @return \Sabre\BargainFinderMax\Structs\ArunkType
     */
    public function setDestinationLocation(\Sabre\BargainFinderMax\Structs\RequestLocationType $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get SideTrip value
     * @return \Sabre\BargainFinderMax\Structs\SideTripType|null
     */
    public function getSideTrip()
    {
        return $this->SideTrip;
    }
    /**
     * Set SideTrip value
     * @param \Sabre\BargainFinderMax\Structs\SideTripType $sideTrip
     * @return \Sabre\BargainFinderMax\Structs\ArunkType
     */
    public function setSideTrip(\Sabre\BargainFinderMax\Structs\SideTripType $sideTrip = null)
    {
        $this->SideTrip = $sideTrip;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\ArunkType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
