<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryFeeGroup Structs
 * Meta informations extracted from the WSDL
 * - documentation: List of requested groups | Ancillary fee group returned
 * @subpackage Structs
 */
class AncillaryFeeGroup extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Name;
    /**
     * The Count
     * @var string
     */
    public $Count;
    /**
     * The AncillaryFeeItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AncillaryFeeItem[]
     */
    public $AncillaryFeeItem;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * Constructor method for AncillaryFeeGroup
     * @uses AncillaryFeeGroup::setCode()
     * @uses AncillaryFeeGroup::setName()
     * @uses AncillaryFeeGroup::setCount()
     * @uses AncillaryFeeGroup::setAncillaryFeeItem()
     * @uses AncillaryFeeGroup::setMessage()
     * @param string $code
     * @param string $name
     * @param string $count
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeItem[] $ancillaryFeeItem
     * @param string $message
     */
    public function __construct($code = null, $name = null, $count = null, array $ancillaryFeeItem = array(), $message = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setCount($count)
            ->setAncillaryFeeItem($ancillaryFeeItem)
            ->setMessage($message);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Count value
     * @return string|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param string $count
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup
     */
    public function setCount($count = null)
    {
        $this->Count = $count;
        return $this;
    }
    /**
     * Get AncillaryFeeItem value
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeItem[]|null
     */
    public function getAncillaryFeeItem()
    {
        return $this->AncillaryFeeItem;
    }
    /**
     * Set AncillaryFeeItem value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeItem[] $ancillaryFeeItem
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup
     */
    public function setAncillaryFeeItem(array $ancillaryFeeItem = array())
    {
        $this->AncillaryFeeItem = $ancillaryFeeItem;
        return $this;
    }
    /**
     * Add item to AncillaryFeeItem value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFeeItem $item
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup
     */
    public function addToAncillaryFeeItem(\Sabre\BargainFinderMax\Structs\AncillaryFeeItem $item)
    {
        $this->AncillaryFeeItem[] = $item;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFeeGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
