<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateLocationLowestFaresType Structs
 * Meta informations extracted from the WSDL
 * - documentation: IntelliSell Type . lowest fare for alternate origin / destination pair.
 * @subpackage Structs
 */
class AlternateLocationLowestFaresType extends AbstractStructBase
{
    /**
     * The OriginLocation
     * @var \Sabre\BargainFinderMax\Structs\ResponseLocationType
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var \Sabre\BargainFinderMax\Structs\ResponseLocationType
     */
    public $DestinationLocation;
    /**
     * The LowestFare
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $LowestFare;
    /**
     * Constructor method for AlternateLocationLowestFaresType
     * @uses AlternateLocationLowestFaresType::setOriginLocation()
     * @uses AlternateLocationLowestFaresType::setDestinationLocation()
     * @uses AlternateLocationLowestFaresType::setLowestFare()
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $originLocation
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $destinationLocation
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $lowestFare
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\ResponseLocationType $originLocation = null, \Sabre\BargainFinderMax\Structs\ResponseLocationType $destinationLocation = null, \Sabre\BargainFinderMax\Structs\CurrencyAmountType $lowestFare = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setLowestFare($lowestFare);
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\BargainFinderMax\Structs\ResponseLocationType|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $originLocation
     * @return \Sabre\BargainFinderMax\Structs\AlternateLocationLowestFaresType
     */
    public function setOriginLocation(\Sabre\BargainFinderMax\Structs\ResponseLocationType $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\BargainFinderMax\Structs\ResponseLocationType|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\BargainFinderMax\Structs\ResponseLocationType $destinationLocation
     * @return \Sabre\BargainFinderMax\Structs\AlternateLocationLowestFaresType
     */
    public function setDestinationLocation(\Sabre\BargainFinderMax\Structs\ResponseLocationType $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get LowestFare value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getLowestFare()
    {
        return $this->LowestFare;
    }
    /**
     * Set LowestFare value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $lowestFare
     * @return \Sabre\BargainFinderMax\Structs\AlternateLocationLowestFaresType
     */
    public function setLowestFare(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $lowestFare = null)
    {
        $this->LowestFare = $lowestFare;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AlternateLocationLowestFaresType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
