<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateDateLowestFaresType Structs
 * Meta informations extracted from the WSDL
 * - documentation: IntelliSell Type . lowest fare for alternate departure / return date times.
 * @subpackage Structs
 */
class AlternateDateLowestFaresType extends AbstractStructBase
{
    /**
     * The DepartureDateTime
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ReturnlDateTime
     * @var string
     */
    public $ReturnlDateTime;
    /**
     * The LowestFare
     * @var \Sabre\BargainFinderMax\Structs\CurrencyAmountType
     */
    public $LowestFare;
    /**
     * Constructor method for AlternateDateLowestFaresType
     * @uses AlternateDateLowestFaresType::setDepartureDateTime()
     * @uses AlternateDateLowestFaresType::setReturnlDateTime()
     * @uses AlternateDateLowestFaresType::setLowestFare()
     * @param string $departureDateTime
     * @param string $returnlDateTime
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $lowestFare
     */
    public function __construct($departureDateTime = null, $returnlDateTime = null, \Sabre\BargainFinderMax\Structs\CurrencyAmountType $lowestFare = null)
    {
        $this
            ->setDepartureDateTime($departureDateTime)
            ->setReturnlDateTime($returnlDateTime)
            ->setLowestFare($lowestFare);
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\BargainFinderMax\Structs\AlternateDateLowestFaresType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ReturnlDateTime value
     * @return string|null
     */
    public function getReturnlDateTime()
    {
        return $this->ReturnlDateTime;
    }
    /**
     * Set ReturnlDateTime value
     * @param string $returnlDateTime
     * @return \Sabre\BargainFinderMax\Structs\AlternateDateLowestFaresType
     */
    public function setReturnlDateTime($returnlDateTime = null)
    {
        $this->ReturnlDateTime = $returnlDateTime;
        return $this;
    }
    /**
     * Get LowestFare value
     * @return \Sabre\BargainFinderMax\Structs\CurrencyAmountType|null
     */
    public function getLowestFare()
    {
        return $this->LowestFare;
    }
    /**
     * Set LowestFare value
     * @param \Sabre\BargainFinderMax\Structs\CurrencyAmountType $lowestFare
     * @return \Sabre\BargainFinderMax\Structs\AlternateDateLowestFaresType
     */
    public function setLowestFare(\Sabre\BargainFinderMax\Structs\CurrencyAmountType $lowestFare = null)
    {
        $this->LowestFare = $lowestFare;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AlternateDateLowestFaresType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
