<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirSearchPrefsType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Defines user preferences to be used in conducting a search. | Request smoking flights in response. Defaults to false - no desire for smoking flights.
 * @subpackage Structs
 */
class AirSearchPrefsType extends AbstractStructBase
{
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - documentation: Specify vendors to include and exclude from the response.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The VendorPrefApplicability
     * Meta informations extracted from the WSDL
     * - documentation: Specifies if online or interline carrier selection logic should be applied for provided carrier type. One instance per carrier type.
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\VendorPrefApplicabilityType[]
     */
    public $VendorPrefApplicability;
    /**
     * The FlightTypePref
     * Meta informations extracted from the WSDL
     * - documentation: Defines preferred flight characteristics to be used in a search.
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FlightTypePrefType
     */
    public $FlightTypePref;
    /**
     * The FareRestrictPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FareRestrictPref[]
     */
    public $FareRestrictPref;
    /**
     * The EquipPref
     * Meta informations extracted from the WSDL
     * - documentation: Defines preferred equipment profile(s) to be used in a search.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\EquipmentTypePref[]
     */
    public $EquipPref;
    /**
     * The CabinPref
     * Meta informations extracted from the WSDL
     * - documentation: Defines preferred cabin(s) to be used in a search. The Cabin type specified in a OriginDestinationInformation/TPA_Extensions overrides this Cabin type for that specific segment/leg. If a Cabin type is not specified in a
     * OriginDestinationInformation/TPA_Extensions the cabin type in this element will be used as default cabin type for that segment/leg.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CabinPrefType[]
     */
    public $CabinPref;
    /**
     * The TicketDistribPref
     * Meta informations extracted from the WSDL
     * - documentation: Defines Distribution prefernces.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TicketDistribPrefType[]
     */
    public $TicketDistribPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The AncillaryFees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AncillaryFees
     */
    public $AncillaryFees;
    /**
     * The FrequentFlyer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FrequentFlyer[]
     */
    public $FrequentFlyer;
    /**
     * The SpanishFamilyDiscount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpanishFamilyDiscount;
    /**
     * The Baggage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\Baggage
     */
    public $Baggage;
    /**
     * The InterlineBrands
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\InterlineBrandsType
     */
    public $InterlineBrands;
    /**
     * The CommissionCodeQualifiers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\CommissionCodeQualifiers
     */
    public $CommissionCodeQualifiers;
    /**
     * The OnTimeRate
     * Meta informations extracted from the WSDL
     * - documentation: Request for flights in response that meet the given Department of Transport on-time rate. This is a number between 0 and 100. | Used for percentage values
     * - use: optional
     * - maxInclusive: 100.00
     * - minInclusive: 0.01
     * @var float
     */
    public $OnTimeRate;
    /**
     * The ETicketDesired
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Request flights that are e-ticketable in the response.
     * - use: optional
     * @var bool
     */
    public $ETicketDesired;
    /**
     * The ValidInterlineTicket
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Request options that are validated on base of interline ticketing aggrement.
     * - use: optional
     * @var bool
     */
    public $ValidInterlineTicket;
    /**
     * The MaxStopsQuantity
     * Meta informations extracted from the WSDL
     * - documentation: Request flights that have no more than the requested number of stops. | Used for Numeric values, from 0 to 999 inclusive
     * - use: optional
     * - maxInclusive: 999
     * - minInclusive: 0
     * @var int
     */
    public $MaxStopsQuantity;
    /**
     * The UseAllFlights
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Each flight should appear at least once.
     * - use: optional
     * @var bool
     */
    public $UseAllFlights;
    /**
     * The AllFlightsData
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Return flights not combinable into roundtrips as one ways is a separate section.
     * - use: optional
     * @var bool
     */
    public $AllFlightsData;
    /**
     * The Hybrid
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: If false no solutions priced outside of ATSE systems will be returned in response for carriers operating in hybrid content distribution model.
     * - use: optional
     * @var bool
     */
    public $Hybrid;
    /**
     * The LookForAlternatives
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: If false no alternative solutions will be returned in response
     * - use: optional
     * @var bool
     */
    public $LookForAlternatives;
    /**
     * The SmokingAllowed
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * Constructor method for AirSearchPrefsType
     * @uses AirSearchPrefsType::setVendorPref()
     * @uses AirSearchPrefsType::setVendorPrefApplicability()
     * @uses AirSearchPrefsType::setFlightTypePref()
     * @uses AirSearchPrefsType::setFareRestrictPref()
     * @uses AirSearchPrefsType::setEquipPref()
     * @uses AirSearchPrefsType::setCabinPref()
     * @uses AirSearchPrefsType::setTicketDistribPref()
     * @uses AirSearchPrefsType::setTPA_Extensions()
     * @uses AirSearchPrefsType::setAncillaryFees()
     * @uses AirSearchPrefsType::setFrequentFlyer()
     * @uses AirSearchPrefsType::setSpanishFamilyDiscount()
     * @uses AirSearchPrefsType::setBaggage()
     * @uses AirSearchPrefsType::setInterlineBrands()
     * @uses AirSearchPrefsType::setCommissionCodeQualifiers()
     * @uses AirSearchPrefsType::setOnTimeRate()
     * @uses AirSearchPrefsType::setETicketDesired()
     * @uses AirSearchPrefsType::setValidInterlineTicket()
     * @uses AirSearchPrefsType::setMaxStopsQuantity()
     * @uses AirSearchPrefsType::setUseAllFlights()
     * @uses AirSearchPrefsType::setAllFlightsData()
     * @uses AirSearchPrefsType::setHybrid()
     * @uses AirSearchPrefsType::setLookForAlternatives()
     * @uses AirSearchPrefsType::setSmokingAllowed()
     * @param \Sabre\BargainFinderMax\Structs\CompanyNamePrefType[] $vendorPref
     * @param \Sabre\BargainFinderMax\Structs\VendorPrefApplicabilityType[] $vendorPrefApplicability
     * @param \Sabre\BargainFinderMax\Structs\FlightTypePrefType $flightTypePref
     * @param \Sabre\BargainFinderMax\Structs\FareRestrictPref[] $fareRestrictPref
     * @param \Sabre\BargainFinderMax\Structs\EquipmentTypePref[] $equipPref
     * @param \Sabre\BargainFinderMax\Structs\CabinPrefType[] $cabinPref
     * @param \Sabre\BargainFinderMax\Structs\TicketDistribPrefType[] $ticketDistribPref
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFees $ancillaryFees
     * @param \Sabre\BargainFinderMax\Structs\FrequentFlyer[] $frequentFlyer
     * @param string $spanishFamilyDiscount
     * @param \Sabre\BargainFinderMax\Structs\Baggage $baggage
     * @param \Sabre\BargainFinderMax\Structs\InterlineBrandsType $interlineBrands
     * @param \Sabre\BargainFinderMax\Structs\CommissionCodeQualifiers $commissionCodeQualifiers
     * @param float $onTimeRate
     * @param bool $eTicketDesired
     * @param bool $validInterlineTicket
     * @param int $maxStopsQuantity
     * @param bool $useAllFlights
     * @param bool $allFlightsData
     * @param bool $hybrid
     * @param bool $lookForAlternatives
     * @param bool $smokingAllowed
     */
    public function __construct(array $vendorPref = array(), array $vendorPrefApplicability = array(), \Sabre\BargainFinderMax\Structs\FlightTypePrefType $flightTypePref = null, array $fareRestrictPref = array(), array $equipPref = array(), array $cabinPref = array(), array $ticketDistribPref = array(), \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, \Sabre\BargainFinderMax\Structs\AncillaryFees $ancillaryFees = null, array $frequentFlyer = array(), $spanishFamilyDiscount = null, \Sabre\BargainFinderMax\Structs\Baggage $baggage = null, \Sabre\BargainFinderMax\Structs\InterlineBrandsType $interlineBrands = null, \Sabre\BargainFinderMax\Structs\CommissionCodeQualifiers $commissionCodeQualifiers = null, $onTimeRate = null, $eTicketDesired = false, $validInterlineTicket = false, $maxStopsQuantity = null, $useAllFlights = false, $allFlightsData = false, $hybrid = true, $lookForAlternatives = true, $smokingAllowed = null)
    {
        $this
            ->setVendorPref($vendorPref)
            ->setVendorPrefApplicability($vendorPrefApplicability)
            ->setFlightTypePref($flightTypePref)
            ->setFareRestrictPref($fareRestrictPref)
            ->setEquipPref($equipPref)
            ->setCabinPref($cabinPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setAncillaryFees($ancillaryFees)
            ->setFrequentFlyer($frequentFlyer)
            ->setSpanishFamilyDiscount($spanishFamilyDiscount)
            ->setBaggage($baggage)
            ->setInterlineBrands($interlineBrands)
            ->setCommissionCodeQualifiers($commissionCodeQualifiers)
            ->setOnTimeRate($onTimeRate)
            ->setETicketDesired($eTicketDesired)
            ->setValidInterlineTicket($validInterlineTicket)
            ->setMaxStopsQuantity($maxStopsQuantity)
            ->setUseAllFlights($useAllFlights)
            ->setAllFlightsData($allFlightsData)
            ->setHybrid($hybrid)
            ->setLookForAlternatives($lookForAlternatives)
            ->setSmokingAllowed($smokingAllowed);
    }
    /**
     * Get VendorPref value
     * @return \Sabre\BargainFinderMax\Structs\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CompanyNamePrefType[] $vendorPref
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CompanyNamePrefType $item
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function addToVendorPref(\Sabre\BargainFinderMax\Structs\CompanyNamePrefType $item)
    {
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPrefApplicability value
     * @return \Sabre\BargainFinderMax\Structs\VendorPrefApplicabilityType[]|null
     */
    public function getVendorPrefApplicability()
    {
        return $this->VendorPrefApplicability;
    }
    /**
     * Set VendorPrefApplicability value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\VendorPrefApplicabilityType[] $vendorPrefApplicability
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setVendorPrefApplicability(array $vendorPrefApplicability = array())
    {
        $this->VendorPrefApplicability = $vendorPrefApplicability;
        return $this;
    }
    /**
     * Add item to VendorPrefApplicability value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\VendorPrefApplicabilityType $item
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function addToVendorPrefApplicability(\Sabre\BargainFinderMax\Structs\VendorPrefApplicabilityType $item)
    {
        $this->VendorPrefApplicability[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \Sabre\BargainFinderMax\Structs\FlightTypePrefType|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * Set FlightTypePref value
     * @param \Sabre\BargainFinderMax\Structs\FlightTypePrefType $flightTypePref
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setFlightTypePref(\Sabre\BargainFinderMax\Structs\FlightTypePrefType $flightTypePref = null)
    {
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Get FareRestrictPref value
     * @return \Sabre\BargainFinderMax\Structs\FareRestrictPref[]|null
     */
    public function getFareRestrictPref()
    {
        return $this->FareRestrictPref;
    }
    /**
     * Set FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareRestrictPref[] $fareRestrictPref
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setFareRestrictPref(array $fareRestrictPref = array())
    {
        $this->FareRestrictPref = $fareRestrictPref;
        return $this;
    }
    /**
     * Add item to FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FareRestrictPref $item
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function addToFareRestrictPref(\Sabre\BargainFinderMax\Structs\FareRestrictPref $item)
    {
        $this->FareRestrictPref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return \Sabre\BargainFinderMax\Structs\EquipmentTypePref[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * Set EquipPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\EquipmentTypePref[] $equipPref
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setEquipPref(array $equipPref = array())
    {
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\EquipmentTypePref $item
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function addToEquipPref(\Sabre\BargainFinderMax\Structs\EquipmentTypePref $item)
    {
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \Sabre\BargainFinderMax\Structs\CabinPrefType[]|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * Set CabinPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CabinPrefType[] $cabinPref
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setCabinPref(array $cabinPref = array())
    {
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Add item to CabinPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\CabinPrefType $item
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function addToCabinPref(\Sabre\BargainFinderMax\Structs\CabinPrefType $item)
    {
        $this->CabinPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \Sabre\BargainFinderMax\Structs\TicketDistribPrefType[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TicketDistribPrefType[] $ticketDistribPref
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\TicketDistribPrefType $item
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function addToTicketDistribPref(\Sabre\BargainFinderMax\Structs\TicketDistribPrefType $item)
    {
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get AncillaryFees value
     * @return \Sabre\BargainFinderMax\Structs\AncillaryFees|null
     */
    public function getAncillaryFees()
    {
        return $this->AncillaryFees;
    }
    /**
     * Set AncillaryFees value
     * @param \Sabre\BargainFinderMax\Structs\AncillaryFees $ancillaryFees
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setAncillaryFees(\Sabre\BargainFinderMax\Structs\AncillaryFees $ancillaryFees = null)
    {
        $this->AncillaryFees = $ancillaryFees;
        return $this;
    }
    /**
     * Get FrequentFlyer value
     * @return \Sabre\BargainFinderMax\Structs\FrequentFlyer[]|null
     */
    public function getFrequentFlyer()
    {
        return $this->FrequentFlyer;
    }
    /**
     * Set FrequentFlyer value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FrequentFlyer[] $frequentFlyer
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setFrequentFlyer(array $frequentFlyer = array())
    {
        $this->FrequentFlyer = $frequentFlyer;
        return $this;
    }
    /**
     * Add item to FrequentFlyer value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FrequentFlyer $item
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function addToFrequentFlyer(\Sabre\BargainFinderMax\Structs\FrequentFlyer $item)
    {
        $this->FrequentFlyer[] = $item;
        return $this;
    }
    /**
     * Get SpanishFamilyDiscount value
     * @return string|null
     */
    public function getSpanishFamilyDiscount()
    {
        return $this->SpanishFamilyDiscount;
    }
    /**
     * Set SpanishFamilyDiscount value
     * @uses \Sabre\BargainFinderMax\Enums\SpanishFamilyDiscount::valueIsValid()
     * @uses \Sabre\BargainFinderMax\Enums\SpanishFamilyDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $spanishFamilyDiscount
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setSpanishFamilyDiscount($spanishFamilyDiscount = null)
    {
        $this->SpanishFamilyDiscount = $spanishFamilyDiscount;
        return $this;
    }
    /**
     * Get Baggage value
     * @return \Sabre\BargainFinderMax\Structs\Baggage|null
     */
    public function getBaggage()
    {
        return $this->Baggage;
    }
    /**
     * Set Baggage value
     * @param \Sabre\BargainFinderMax\Structs\Baggage $baggage
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setBaggage(\Sabre\BargainFinderMax\Structs\Baggage $baggage = null)
    {
        $this->Baggage = $baggage;
        return $this;
    }
    /**
     * Get InterlineBrands value
     * @return \Sabre\BargainFinderMax\Structs\InterlineBrandsType|null
     */
    public function getInterlineBrands()
    {
        return $this->InterlineBrands;
    }
    /**
     * Set InterlineBrands value
     * @param \Sabre\BargainFinderMax\Structs\InterlineBrandsType $interlineBrands
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setInterlineBrands(\Sabre\BargainFinderMax\Structs\InterlineBrandsType $interlineBrands = null)
    {
        $this->InterlineBrands = $interlineBrands;
        return $this;
    }
    /**
     * Get CommissionCodeQualifiers value
     * @return \Sabre\BargainFinderMax\Structs\CommissionCodeQualifiers|null
     */
    public function getCommissionCodeQualifiers()
    {
        return $this->CommissionCodeQualifiers;
    }
    /**
     * Set CommissionCodeQualifiers value
     * @param \Sabre\BargainFinderMax\Structs\CommissionCodeQualifiers $commissionCodeQualifiers
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setCommissionCodeQualifiers(\Sabre\BargainFinderMax\Structs\CommissionCodeQualifiers $commissionCodeQualifiers = null)
    {
        $this->CommissionCodeQualifiers = $commissionCodeQualifiers;
        return $this;
    }
    /**
     * Get OnTimeRate value
     * @return float|null
     */
    public function getOnTimeRate()
    {
        return $this->OnTimeRate;
    }
    /**
     * Set OnTimeRate value
     * @param float $onTimeRate
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setOnTimeRate($onTimeRate = null)
    {
        $this->OnTimeRate = $onTimeRate;
        return $this;
    }
    /**
     * Get ETicketDesired value
     * @return bool|null
     */
    public function getETicketDesired()
    {
        return $this->ETicketDesired;
    }
    /**
     * Set ETicketDesired value
     * @param bool $eTicketDesired
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setETicketDesired($eTicketDesired = false)
    {
        $this->ETicketDesired = $eTicketDesired;
        return $this;
    }
    /**
     * Get ValidInterlineTicket value
     * @return bool|null
     */
    public function getValidInterlineTicket()
    {
        return $this->ValidInterlineTicket;
    }
    /**
     * Set ValidInterlineTicket value
     * @param bool $validInterlineTicket
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setValidInterlineTicket($validInterlineTicket = false)
    {
        $this->ValidInterlineTicket = $validInterlineTicket;
        return $this;
    }
    /**
     * Get MaxStopsQuantity value
     * @return int|null
     */
    public function getMaxStopsQuantity()
    {
        return $this->MaxStopsQuantity;
    }
    /**
     * Set MaxStopsQuantity value
     * @param int $maxStopsQuantity
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setMaxStopsQuantity($maxStopsQuantity = null)
    {
        $this->MaxStopsQuantity = $maxStopsQuantity;
        return $this;
    }
    /**
     * Get UseAllFlights value
     * @return bool|null
     */
    public function getUseAllFlights()
    {
        return $this->UseAllFlights;
    }
    /**
     * Set UseAllFlights value
     * @param bool $useAllFlights
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setUseAllFlights($useAllFlights = false)
    {
        $this->UseAllFlights = $useAllFlights;
        return $this;
    }
    /**
     * Get AllFlightsData value
     * @return bool|null
     */
    public function getAllFlightsData()
    {
        return $this->AllFlightsData;
    }
    /**
     * Set AllFlightsData value
     * @param bool $allFlightsData
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setAllFlightsData($allFlightsData = false)
    {
        $this->AllFlightsData = $allFlightsData;
        return $this;
    }
    /**
     * Get Hybrid value
     * @return bool|null
     */
    public function getHybrid()
    {
        return $this->Hybrid;
    }
    /**
     * Set Hybrid value
     * @param bool $hybrid
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setHybrid($hybrid = true)
    {
        $this->Hybrid = $hybrid;
        return $this;
    }
    /**
     * Get LookForAlternatives value
     * @return bool|null
     */
    public function getLookForAlternatives()
    {
        return $this->LookForAlternatives;
    }
    /**
     * Set LookForAlternatives value
     * @param bool $lookForAlternatives
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setLookForAlternatives($lookForAlternatives = true)
    {
        $this->LookForAlternatives = $lookForAlternatives;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AirSearchPrefsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
