<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryPricingInfoType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Pricing Information for an Air Itinerary
 * @subpackage Structs
 */
class AirItineraryPricingInfoType extends AbstractStructBase
{
    /**
     * The ItinTotalFare
     * Meta informations extracted from the WSDL
     * - documentation: Total price of the itinerary
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\ItinTotalFareType
     */
    public $ItinTotalFare;
    /**
     * The PTC_FareBreakdowns
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\PTC_FareBreakdowns
     */
    public $PTC_FareBreakdowns;
    /**
     * The FareInfos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FareInfos
     */
    public $FareInfos;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The LastTicketDate
     * Meta informations extracted from the WSDL
     * - documentation: Last day to ticket. | Allows for the specification of a date time or just time.
     * - union: string | time
     * @var string
     */
    public $LastTicketDate;
    /**
     * The PrivateFareType
     * @var string
     */
    public $PrivateFareType;
    /**
     * The SpanishFamilyDiscountIndicator
     * @var string
     */
    public $SpanishFamilyDiscountIndicator;
    /**
     * The FlexibleFareID
     * Meta informations extracted from the WSDL
     * - documentation: If the fare is an additional flexible fare, this is the fare group ID
     * - use: optional
     * @var int
     */
    public $FlexibleFareID;
    /**
     * The PricingSource
     * Meta informations extracted from the WSDL
     * - documentation: Used to indicate whether the pricing is public or private | It can be used to indicate whether the fare is public or private.
     * - pattern: [0-9A-Z_]{1,13}
     * @var string
     */
    public $PricingSource;
    /**
     * The PricingSubSource
     * Meta informations extracted from the WSDL
     * - documentation: Pricing sub source.
     * - minLength: 1
     * - pattern: [A-Z_]{1,}
     * @var string
     */
    public $PricingSubSource;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: (MultiPCC) Information about Pseudo City Code for wich the fare was produced.
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The BrandID
     * Meta informations extracted from the WSDL
     * - documentation: Used to indicate brand code (e.g. SS for SuperSaver) or type of Fare (e.g. Sale Fare or Full Coach and so on...)
     * @var string
     */
    public $BrandID;
    /**
     * The FareReturned
     * Meta informations extracted from the WSDL
     * - documentation: Boolean to indicate if a fare returned for the BrandID or not (true if fare is returned and false if no fare returned)
     * @var bool
     */
    public $FareReturned;
    /**
     * The FareStatus
     * Meta informations extracted from the WSDL
     * - documentation: Detailed reason why fare could not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable".
     * @var string
     */
    public $FareStatus;
    /**
     * The CachedItin
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the itin is from Cache. If true, it is from Cache.
     * @var bool
     */
    public $CachedItin;
    /**
     * The CachePartition
     * Meta informations extracted from the WSDL
     * - documentation: Indicates source partition of cached itin
     * @var string
     */
    public $CachePartition;
    /**
     * The CachePartitionPriority
     * Meta informations extracted from the WSDL
     * - documentation: Indicates source partition priority of cached itin
     * @var int
     */
    public $CachePartitionPriority;
    /**
     * The CacheVersion
     * Meta informations extracted from the WSDL
     * - documentation: Indicates source version of cached itin
     * @var string
     */
    public $CacheVersion;
    /**
     * The TimeToLive
     * Meta informations extracted from the WSDL
     * - documentation: Time to live in cache (in minutes).
     * @var int
     */
    public $TimeToLive;
    /**
     * The HoursSinceCreation
     * Meta informations extracted from the WSDL
     * - documentation: Hours since option was created and stored in cache (in hours).
     * @var int
     */
    public $HoursSinceCreation;
    /**
     * The AlternateCityOption
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that this option is alternate dates option.
     * @var bool
     */
    public $AlternateCityOption;
    /**
     * The BrandsOnAnyMarket
     * Meta informations extracted from the WSDL
     * - documentation: True if itin has any brand on any fare market
     * @var bool
     */
    public $BrandsOnAnyMarket;
    /**
     * The Repriced
     * Meta informations extracted from the WSDL
     * - documentation: True if itin has been repriced in WPNI verification flow
     * @var bool
     */
    public $Repriced;
    /**
     * The PreviousExchangeDate
     * Meta informations extracted from the WSDL
     * - documentation: Previous Exchange Date
     * @var string
     */
    public $PreviousExchangeDate;
    /**
     * The ReissueExchange
     * @var string
     */
    public $ReissueExchange;
    /**
     * The AdvancedPurchaseDate
     * @var string
     */
    public $AdvancedPurchaseDate;
    /**
     * The PurchaseByDate
     * @var string
     */
    public $PurchaseByDate;
    /**
     * Constructor method for AirItineraryPricingInfoType
     * @uses AirItineraryPricingInfoType::setItinTotalFare()
     * @uses AirItineraryPricingInfoType::setPTC_FareBreakdowns()
     * @uses AirItineraryPricingInfoType::setFareInfos()
     * @uses AirItineraryPricingInfoType::setTPA_Extensions()
     * @uses AirItineraryPricingInfoType::setLastTicketDate()
     * @uses AirItineraryPricingInfoType::setPrivateFareType()
     * @uses AirItineraryPricingInfoType::setSpanishFamilyDiscountIndicator()
     * @uses AirItineraryPricingInfoType::setFlexibleFareID()
     * @uses AirItineraryPricingInfoType::setPricingSource()
     * @uses AirItineraryPricingInfoType::setPricingSubSource()
     * @uses AirItineraryPricingInfoType::setPseudoCityCode()
     * @uses AirItineraryPricingInfoType::setBrandID()
     * @uses AirItineraryPricingInfoType::setFareReturned()
     * @uses AirItineraryPricingInfoType::setFareStatus()
     * @uses AirItineraryPricingInfoType::setCachedItin()
     * @uses AirItineraryPricingInfoType::setCachePartition()
     * @uses AirItineraryPricingInfoType::setCachePartitionPriority()
     * @uses AirItineraryPricingInfoType::setCacheVersion()
     * @uses AirItineraryPricingInfoType::setTimeToLive()
     * @uses AirItineraryPricingInfoType::setHoursSinceCreation()
     * @uses AirItineraryPricingInfoType::setAlternateCityOption()
     * @uses AirItineraryPricingInfoType::setBrandsOnAnyMarket()
     * @uses AirItineraryPricingInfoType::setRepriced()
     * @uses AirItineraryPricingInfoType::setPreviousExchangeDate()
     * @uses AirItineraryPricingInfoType::setReissueExchange()
     * @uses AirItineraryPricingInfoType::setAdvancedPurchaseDate()
     * @uses AirItineraryPricingInfoType::setPurchaseByDate()
     * @param \Sabre\BargainFinderMax\Structs\ItinTotalFareType $itinTotalFare
     * @param \Sabre\BargainFinderMax\Structs\PTC_FareBreakdowns $pTC_FareBreakdowns
     * @param \Sabre\BargainFinderMax\Structs\FareInfos $fareInfos
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @param string $lastTicketDate
     * @param string $privateFareType
     * @param string $spanishFamilyDiscountIndicator
     * @param int $flexibleFareID
     * @param string $pricingSource
     * @param string $pricingSubSource
     * @param string $pseudoCityCode
     * @param string $brandID
     * @param bool $fareReturned
     * @param string $fareStatus
     * @param bool $cachedItin
     * @param string $cachePartition
     * @param int $cachePartitionPriority
     * @param string $cacheVersion
     * @param int $timeToLive
     * @param int $hoursSinceCreation
     * @param bool $alternateCityOption
     * @param bool $brandsOnAnyMarket
     * @param bool $repriced
     * @param string $previousExchangeDate
     * @param string $reissueExchange
     * @param string $advancedPurchaseDate
     * @param string $purchaseByDate
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\ItinTotalFareType $itinTotalFare = null, \Sabre\BargainFinderMax\Structs\PTC_FareBreakdowns $pTC_FareBreakdowns = null, \Sabre\BargainFinderMax\Structs\FareInfos $fareInfos = null, \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null, $lastTicketDate = null, $privateFareType = null, $spanishFamilyDiscountIndicator = null, $flexibleFareID = null, $pricingSource = null, $pricingSubSource = null, $pseudoCityCode = null, $brandID = null, $fareReturned = null, $fareStatus = null, $cachedItin = null, $cachePartition = null, $cachePartitionPriority = null, $cacheVersion = null, $timeToLive = null, $hoursSinceCreation = null, $alternateCityOption = null, $brandsOnAnyMarket = null, $repriced = null, $previousExchangeDate = null, $reissueExchange = null, $advancedPurchaseDate = null, $purchaseByDate = null)
    {
        $this
            ->setItinTotalFare($itinTotalFare)
            ->setPTC_FareBreakdowns($pTC_FareBreakdowns)
            ->setFareInfos($fareInfos)
            ->setTPA_Extensions($tPA_Extensions)
            ->setLastTicketDate($lastTicketDate)
            ->setPrivateFareType($privateFareType)
            ->setSpanishFamilyDiscountIndicator($spanishFamilyDiscountIndicator)
            ->setFlexibleFareID($flexibleFareID)
            ->setPricingSource($pricingSource)
            ->setPricingSubSource($pricingSubSource)
            ->setPseudoCityCode($pseudoCityCode)
            ->setBrandID($brandID)
            ->setFareReturned($fareReturned)
            ->setFareStatus($fareStatus)
            ->setCachedItin($cachedItin)
            ->setCachePartition($cachePartition)
            ->setCachePartitionPriority($cachePartitionPriority)
            ->setCacheVersion($cacheVersion)
            ->setTimeToLive($timeToLive)
            ->setHoursSinceCreation($hoursSinceCreation)
            ->setAlternateCityOption($alternateCityOption)
            ->setBrandsOnAnyMarket($brandsOnAnyMarket)
            ->setRepriced($repriced)
            ->setPreviousExchangeDate($previousExchangeDate)
            ->setReissueExchange($reissueExchange)
            ->setAdvancedPurchaseDate($advancedPurchaseDate)
            ->setPurchaseByDate($purchaseByDate);
    }
    /**
     * Get ItinTotalFare value
     * @return \Sabre\BargainFinderMax\Structs\ItinTotalFareType|null
     */
    public function getItinTotalFare()
    {
        return $this->ItinTotalFare;
    }
    /**
     * Set ItinTotalFare value
     * @param \Sabre\BargainFinderMax\Structs\ItinTotalFareType $itinTotalFare
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setItinTotalFare(\Sabre\BargainFinderMax\Structs\ItinTotalFareType $itinTotalFare = null)
    {
        $this->ItinTotalFare = $itinTotalFare;
        return $this;
    }
    /**
     * Get PTC_FareBreakdowns value
     * @return \Sabre\BargainFinderMax\Structs\PTC_FareBreakdowns|null
     */
    public function getPTC_FareBreakdowns()
    {
        return $this->PTC_FareBreakdowns;
    }
    /**
     * Set PTC_FareBreakdowns value
     * @param \Sabre\BargainFinderMax\Structs\PTC_FareBreakdowns $pTC_FareBreakdowns
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setPTC_FareBreakdowns(\Sabre\BargainFinderMax\Structs\PTC_FareBreakdowns $pTC_FareBreakdowns = null)
    {
        $this->PTC_FareBreakdowns = $pTC_FareBreakdowns;
        return $this;
    }
    /**
     * Get FareInfos value
     * @return \Sabre\BargainFinderMax\Structs\FareInfos|null
     */
    public function getFareInfos()
    {
        return $this->FareInfos;
    }
    /**
     * Set FareInfos value
     * @param \Sabre\BargainFinderMax\Structs\FareInfos $fareInfos
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setFareInfos(\Sabre\BargainFinderMax\Structs\FareInfos $fareInfos = null)
    {
        $this->FareInfos = $fareInfos;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\BargainFinderMax\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setTPA_Extensions(\Sabre\BargainFinderMax\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get LastTicketDate value
     * @return string|null
     */
    public function getLastTicketDate()
    {
        return $this->LastTicketDate;
    }
    /**
     * Set LastTicketDate value
     * @param string $lastTicketDate
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setLastTicketDate($lastTicketDate = null)
    {
        $this->LastTicketDate = $lastTicketDate;
        return $this;
    }
    /**
     * Get PrivateFareType value
     * @return string|null
     */
    public function getPrivateFareType()
    {
        return $this->PrivateFareType;
    }
    /**
     * Set PrivateFareType value
     * @param string $privateFareType
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setPrivateFareType($privateFareType = null)
    {
        $this->PrivateFareType = $privateFareType;
        return $this;
    }
    /**
     * Get SpanishFamilyDiscountIndicator value
     * @return string|null
     */
    public function getSpanishFamilyDiscountIndicator()
    {
        return $this->SpanishFamilyDiscountIndicator;
    }
    /**
     * Set SpanishFamilyDiscountIndicator value
     * @param string $spanishFamilyDiscountIndicator
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setSpanishFamilyDiscountIndicator($spanishFamilyDiscountIndicator = null)
    {
        $this->SpanishFamilyDiscountIndicator = $spanishFamilyDiscountIndicator;
        return $this;
    }
    /**
     * Get FlexibleFareID value
     * @return int|null
     */
    public function getFlexibleFareID()
    {
        return $this->FlexibleFareID;
    }
    /**
     * Set FlexibleFareID value
     * @param int $flexibleFareID
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setFlexibleFareID($flexibleFareID = null)
    {
        $this->FlexibleFareID = $flexibleFareID;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setPricingSource($pricingSource = null)
    {
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get PricingSubSource value
     * @return string|null
     */
    public function getPricingSubSource()
    {
        return $this->PricingSubSource;
    }
    /**
     * Set PricingSubSource value
     * @param string $pricingSubSource
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setPricingSubSource($pricingSubSource = null)
    {
        $this->PricingSubSource = $pricingSubSource;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get FareReturned value
     * @return bool|null
     */
    public function getFareReturned()
    {
        return $this->FareReturned;
    }
    /**
     * Set FareReturned value
     * @param bool $fareReturned
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setFareReturned($fareReturned = null)
    {
        $this->FareReturned = $fareReturned;
        return $this;
    }
    /**
     * Get FareStatus value
     * @return string|null
     */
    public function getFareStatus()
    {
        return $this->FareStatus;
    }
    /**
     * Set FareStatus value
     * @param string $fareStatus
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setFareStatus($fareStatus = null)
    {
        $this->FareStatus = $fareStatus;
        return $this;
    }
    /**
     * Get CachedItin value
     * @return bool|null
     */
    public function getCachedItin()
    {
        return $this->CachedItin;
    }
    /**
     * Set CachedItin value
     * @param bool $cachedItin
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setCachedItin($cachedItin = null)
    {
        $this->CachedItin = $cachedItin;
        return $this;
    }
    /**
     * Get CachePartition value
     * @return string|null
     */
    public function getCachePartition()
    {
        return $this->CachePartition;
    }
    /**
     * Set CachePartition value
     * @param string $cachePartition
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setCachePartition($cachePartition = null)
    {
        $this->CachePartition = $cachePartition;
        return $this;
    }
    /**
     * Get CachePartitionPriority value
     * @return int|null
     */
    public function getCachePartitionPriority()
    {
        return $this->CachePartitionPriority;
    }
    /**
     * Set CachePartitionPriority value
     * @param int $cachePartitionPriority
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setCachePartitionPriority($cachePartitionPriority = null)
    {
        $this->CachePartitionPriority = $cachePartitionPriority;
        return $this;
    }
    /**
     * Get CacheVersion value
     * @return string|null
     */
    public function getCacheVersion()
    {
        return $this->CacheVersion;
    }
    /**
     * Set CacheVersion value
     * @param string $cacheVersion
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setCacheVersion($cacheVersion = null)
    {
        $this->CacheVersion = $cacheVersion;
        return $this;
    }
    /**
     * Get TimeToLive value
     * @return int|null
     */
    public function getTimeToLive()
    {
        return $this->TimeToLive;
    }
    /**
     * Set TimeToLive value
     * @param int $timeToLive
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setTimeToLive($timeToLive = null)
    {
        $this->TimeToLive = $timeToLive;
        return $this;
    }
    /**
     * Get HoursSinceCreation value
     * @return int|null
     */
    public function getHoursSinceCreation()
    {
        return $this->HoursSinceCreation;
    }
    /**
     * Set HoursSinceCreation value
     * @param int $hoursSinceCreation
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setHoursSinceCreation($hoursSinceCreation = null)
    {
        $this->HoursSinceCreation = $hoursSinceCreation;
        return $this;
    }
    /**
     * Get AlternateCityOption value
     * @return bool|null
     */
    public function getAlternateCityOption()
    {
        return $this->AlternateCityOption;
    }
    /**
     * Set AlternateCityOption value
     * @param bool $alternateCityOption
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setAlternateCityOption($alternateCityOption = null)
    {
        $this->AlternateCityOption = $alternateCityOption;
        return $this;
    }
    /**
     * Get BrandsOnAnyMarket value
     * @return bool|null
     */
    public function getBrandsOnAnyMarket()
    {
        return $this->BrandsOnAnyMarket;
    }
    /**
     * Set BrandsOnAnyMarket value
     * @param bool $brandsOnAnyMarket
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setBrandsOnAnyMarket($brandsOnAnyMarket = null)
    {
        $this->BrandsOnAnyMarket = $brandsOnAnyMarket;
        return $this;
    }
    /**
     * Get Repriced value
     * @return bool|null
     */
    public function getRepriced()
    {
        return $this->Repriced;
    }
    /**
     * Set Repriced value
     * @param bool $repriced
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setRepriced($repriced = null)
    {
        $this->Repriced = $repriced;
        return $this;
    }
    /**
     * Get PreviousExchangeDate value
     * @return string|null
     */
    public function getPreviousExchangeDate()
    {
        return $this->PreviousExchangeDate;
    }
    /**
     * Set PreviousExchangeDate value
     * @param string $previousExchangeDate
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setPreviousExchangeDate($previousExchangeDate = null)
    {
        $this->PreviousExchangeDate = $previousExchangeDate;
        return $this;
    }
    /**
     * Get ReissueExchange value
     * @return string|null
     */
    public function getReissueExchange()
    {
        return $this->ReissueExchange;
    }
    /**
     * Set ReissueExchange value
     * @param string $reissueExchange
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setReissueExchange($reissueExchange = null)
    {
        $this->ReissueExchange = $reissueExchange;
        return $this;
    }
    /**
     * Get AdvancedPurchaseDate value
     * @return string|null
     */
    public function getAdvancedPurchaseDate()
    {
        return $this->AdvancedPurchaseDate;
    }
    /**
     * Set AdvancedPurchaseDate value
     * @param string $advancedPurchaseDate
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setAdvancedPurchaseDate($advancedPurchaseDate = null)
    {
        $this->AdvancedPurchaseDate = $advancedPurchaseDate;
        return $this;
    }
    /**
     * Get PurchaseByDate value
     * @return string|null
     */
    public function getPurchaseByDate()
    {
        return $this->PurchaseByDate;
    }
    /**
     * Set PurchaseByDate value
     * @param string $purchaseByDate
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public function setPurchaseByDate($purchaseByDate = null)
    {
        $this->PurchaseByDate = $purchaseByDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
