<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvResTicketingType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Container used to hold information regarding advance reservation and/or advance ticketing.
 * @subpackage Structs
 */
class AdvResTicketingType extends AbstractStructBase
{
    /**
     * The AdvReservation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AdvReservation
     */
    public $AdvReservation;
    /**
     * The AdvTicketing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AdvTicketing
     */
    public $AdvTicketing;
    /**
     * The AdvResInd
     * Meta informations extracted from the WSDL
     * - documentation: Indicator for identifying whether or not advance reservation restrictions are involved in the request or response.
     * @var bool
     */
    public $AdvResInd;
    /**
     * The AdvTicketingInd
     * Meta informations extracted from the WSDL
     * - documentation: Indicator for identifying whether or not advance ticketing restrictions are involved in the request or response.
     * @var bool
     */
    public $AdvTicketingInd;
    /**
     * Constructor method for AdvResTicketingType
     * @uses AdvResTicketingType::setAdvReservation()
     * @uses AdvResTicketingType::setAdvTicketing()
     * @uses AdvResTicketingType::setAdvResInd()
     * @uses AdvResTicketingType::setAdvTicketingInd()
     * @param \Sabre\BargainFinderMax\Structs\AdvReservation $advReservation
     * @param \Sabre\BargainFinderMax\Structs\AdvTicketing $advTicketing
     * @param bool $advResInd
     * @param bool $advTicketingInd
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\AdvReservation $advReservation = null, \Sabre\BargainFinderMax\Structs\AdvTicketing $advTicketing = null, $advResInd = null, $advTicketingInd = null)
    {
        $this
            ->setAdvReservation($advReservation)
            ->setAdvTicketing($advTicketing)
            ->setAdvResInd($advResInd)
            ->setAdvTicketingInd($advTicketingInd);
    }
    /**
     * Get AdvReservation value
     * @return \Sabre\BargainFinderMax\Structs\AdvReservation|null
     */
    public function getAdvReservation()
    {
        return $this->AdvReservation;
    }
    /**
     * Set AdvReservation value
     * @param \Sabre\BargainFinderMax\Structs\AdvReservation $advReservation
     * @return \Sabre\BargainFinderMax\Structs\AdvResTicketingType
     */
    public function setAdvReservation(\Sabre\BargainFinderMax\Structs\AdvReservation $advReservation = null)
    {
        $this->AdvReservation = $advReservation;
        return $this;
    }
    /**
     * Get AdvTicketing value
     * @return \Sabre\BargainFinderMax\Structs\AdvTicketing|null
     */
    public function getAdvTicketing()
    {
        return $this->AdvTicketing;
    }
    /**
     * Set AdvTicketing value
     * @param \Sabre\BargainFinderMax\Structs\AdvTicketing $advTicketing
     * @return \Sabre\BargainFinderMax\Structs\AdvResTicketingType
     */
    public function setAdvTicketing(\Sabre\BargainFinderMax\Structs\AdvTicketing $advTicketing = null)
    {
        $this->AdvTicketing = $advTicketing;
        return $this;
    }
    /**
     * Get AdvResInd value
     * @return bool|null
     */
    public function getAdvResInd()
    {
        return $this->AdvResInd;
    }
    /**
     * Set AdvResInd value
     * @param bool $advResInd
     * @return \Sabre\BargainFinderMax\Structs\AdvResTicketingType
     */
    public function setAdvResInd($advResInd = null)
    {
        $this->AdvResInd = $advResInd;
        return $this;
    }
    /**
     * Get AdvTicketingInd value
     * @return bool|null
     */
    public function getAdvTicketingInd()
    {
        return $this->AdvTicketingInd;
    }
    /**
     * Set AdvTicketingInd value
     * @param bool $advTicketingInd
     * @return \Sabre\BargainFinderMax\Structs\AdvResTicketingType
     */
    public function setAdvTicketingInd($advTicketingInd = null)
    {
        $this->AdvTicketingInd = $advTicketingInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AdvResTicketingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
