<?php

namespace Sabre\BargainFinderMax\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalFares Structs
 * @subpackage Structs
 */
class AdditionalFares extends AbstractStructBase
{
    /**
     * The AirItineraryPricingInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo
     */
    public $AirItineraryPricingInfo;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - documentation: Provides for free form descriptive information for the priced itinerary.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\FreeTextType[]
     */
    public $Notes;
    /**
     * The TicketingInfo
     * Meta informations extracted from the WSDL
     * - documentation: Information about ticketing (including eTicketNumber).
     * - minOccurs: 0
     * @var \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type
     */
    public $TicketingInfo;
    /**
     * The MultipleTickets
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that itinerary should be sold on multiple separate tickets
     * - use: optional
     * @var bool
     */
    public $MultipleTickets;
    /**
     * Constructor method for AdditionalFares
     * @uses AdditionalFares::setAirItineraryPricingInfo()
     * @uses AdditionalFares::setNotes()
     * @uses AdditionalFares::setTicketingInfo()
     * @uses AdditionalFares::setMultipleTickets()
     * @param \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo $airItineraryPricingInfo
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType[] $notes
     * @param \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo
     * @param bool $multipleTickets
     */
    public function __construct(\Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo $airItineraryPricingInfo = null, array $notes = array(), \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo = null, $multipleTickets = null)
    {
        $this
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setNotes($notes)
            ->setTicketingInfo($ticketingInfo)
            ->setMultipleTickets($multipleTickets);
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @param \Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo $airItineraryPricingInfo
     * @return \Sabre\BargainFinderMax\Structs\AdditionalFares
     */
    public function setAirItineraryPricingInfo(\Sabre\BargainFinderMax\Structs\AirItineraryPricingInfo $airItineraryPricingInfo = null)
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Get Notes value
     * @return \Sabre\BargainFinderMax\Structs\FreeTextType[]|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType[] $notes
     * @return \Sabre\BargainFinderMax\Structs\AdditionalFares
     */
    public function setNotes(array $notes = array())
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Add item to Notes value
     * @throws \InvalidArgumentException
     * @param \Sabre\BargainFinderMax\Structs\FreeTextType $item
     * @return \Sabre\BargainFinderMax\Structs\AdditionalFares
     */
    public function addToNotes(\Sabre\BargainFinderMax\Structs\FreeTextType $item)
    {
        $this->Notes[] = $item;
        return $this;
    }
    /**
     * Get TicketingInfo value
     * @return \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type|null
     */
    public function getTicketingInfo()
    {
        return $this->TicketingInfo;
    }
    /**
     * Set TicketingInfo value
     * @param \Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo
     * @return \Sabre\BargainFinderMax\Structs\AdditionalFares
     */
    public function setTicketingInfo(\Sabre\BargainFinderMax\Structs\TicketingInfoRS_Type $ticketingInfo = null)
    {
        $this->TicketingInfo = $ticketingInfo;
        return $this;
    }
    /**
     * Get MultipleTickets value
     * @return bool|null
     */
    public function getMultipleTickets()
    {
        return $this->MultipleTickets;
    }
    /**
     * Set MultipleTickets value
     * @param bool $multipleTickets
     * @return \Sabre\BargainFinderMax\Structs\AdditionalFares
     */
    public function setMultipleTickets($multipleTickets = null)
    {
        $this->MultipleTickets = $multipleTickets;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\BargainFinderMax\Structs\AdditionalFares
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
