<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for SpanishFamilyDiscount Enums
 * Meta informations extracted from the WSDL
 * - documentation: Spanish Discount indicator with values of "A", "B", "C" where "A" indicates Spanish Large Family discount only "B" indicates Spanish Large Family discount + Spanish Islander discount "C" indicates Spanish Islander discount only
 * @subpackage Enumerations
 */
class SpanishFamilyDiscount
{
    /**
     * Constant for value 'A'
     * @return string 'A'
     */
    const VALUE_A = 'A';
    /**
     * Constant for value 'B'
     * @return string 'B'
     */
    const VALUE_B = 'B';
    /**
     * Constant for value 'C'
     * @return string 'C'
     */
    const VALUE_C = 'C';
    /**
     * The Level
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Level;
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_A
     * @uses self::VALUE_B
     * @uses self::VALUE_C
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_A,
            self::VALUE_B,
            self::VALUE_C,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
