<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for FareDirectionality Enums
 * @subpackage Enumerations
 */
class FareDirectionality
{
    /**
     * Constant for value 'TO'
     * @return string 'TO'
     */
    const VALUE_TO = 'TO';
    /**
     * Constant for value 'FROM'
     * @return string 'FROM'
     */
    const VALUE_FROM = 'FROM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TO
     * @uses self::VALUE_FROM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TO,
            self::VALUE_FROM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
