<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for BaggageProvisionType Enums
 * Meta informations extracted from the WSDL
 * - documentation: A - Checked Baggage Allowance, C - Day of Check-in Charges, B - Carry-on Baggage Allowance, CC - Carry-on Baggage Charges, E - Baggage Embargo, P - Prepaid Checked Baggage Charges, EE - Generic Embargo: No Excess Permitted | A -
 * Checked Baggage Allowance, C - Day of Check-in Charges, B - Carry-on Baggage Allowance, CC - Carry-on Baggage Charges, E - Baggage Embargo, P - Prepaid Checked Baggage Charges, EE - Generic Embargo: No Excess Permitted
 * @subpackage Enumerations
 */
class BaggageProvisionType
{
    /**
     * Constant for value 'A'
     * @return string 'A'
     */
    const VALUE_A = 'A';
    /**
     * Constant for value 'C'
     * @return string 'C'
     */
    const VALUE_C = 'C';
    /**
     * Constant for value 'B'
     * @return string 'B'
     */
    const VALUE_B = 'B';
    /**
     * Constant for value 'CC'
     * @return string 'CC'
     */
    const VALUE_CC = 'CC';
    /**
     * Constant for value 'E'
     * @return string 'E'
     */
    const VALUE_E = 'E';
    /**
     * Constant for value 'P'
     * @return string 'P'
     */
    const VALUE_P = 'P';
    /**
     * Constant for value 'EE'
     * @return string 'EE'
     */
    const VALUE_EE = 'EE';
    /**
     * Constant for value ''
     * @return string ''
     */
    const VALUE_ = '';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_A
     * @uses self::VALUE_C
     * @uses self::VALUE_B
     * @uses self::VALUE_CC
     * @uses self::VALUE_E
     * @uses self::VALUE_P
     * @uses self::VALUE_EE
     * @uses self::VALUE_
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_A,
            self::VALUE_C,
            self::VALUE_B,
            self::VALUE_CC,
            self::VALUE_E,
            self::VALUE_P,
            self::VALUE_EE,
            self::VALUE_,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
