<?php

namespace Sabre\BargainFinderMax\Enums;

/**
 * This class stands for AllowedExcludedPreferLevelType Enums
 * Meta informations extracted from the WSDL
 * - documentation: Used to specify a preference level for something that is or will be requested (e.g. a supplier of a service, a type of service, a form of payment, etc.). Available levels: "Only" and "Unacceptable".
 * @subpackage Enumerations
 */
class AllowedExcludedPreferLevelType
{
    /**
     * Constant for value 'Only'
     * @return string 'Only'
     */
    const VALUE_ONLY = 'Only';
    /**
     * Constant for value 'Unacceptable'
     * @return string 'Unacceptable'
     */
    const VALUE_UNACCEPTABLE = 'Unacceptable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONLY
     * @uses self::VALUE_UNACCEPTABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONLY,
            self::VALUE_UNACCEPTABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
