<?php

namespace Sabre\TokenCreate\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for From Structs
 * @subpackage Structs
 */
class From extends AbstractStructBase
{
    /**
     * The PartyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:PartyId
     * @var \Sabre\TokenCreate\Structs\PartyId[]
     */
    public $PartyId;
    /**
     * The Role
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - minLength: 1
     * @var string
     */
    public $Role;
    /**
     * Constructor method for From
     * @uses From::setPartyId()
     * @uses From::setRole()
     * @param \Sabre\TokenCreate\Structs\PartyId[] $partyId
     * @param string $role
     */
    public function __construct(array $partyId = array(), $role = null)
    {
        $this
            ->setPartyId($partyId)
            ->setRole($role);
    }
    /**
     * Get PartyId value
     * @return \Sabre\TokenCreate\Structs\PartyId[]|null
     */
    public function getPartyId()
    {
        return $this->PartyId;
    }
    /**
     * Set PartyId value
     * @throws \InvalidArgumentException
     * @param \Sabre\TokenCreate\Structs\PartyId[] $partyId
     * @return \Sabre\TokenCreate\Structs\From
     */
    public function setPartyId(array $partyId = array())
    {
        $this->PartyId = $partyId;
        return $this;
    }
    /**
     * Add item to PartyId value
     * @throws \InvalidArgumentException
     * @param \Sabre\TokenCreate\Structs\PartyId $item
     * @return \Sabre\TokenCreate\Structs\From
     */
    public function addToPartyId(\Sabre\TokenCreate\Structs\PartyId $item)
    {
        $this->PartyId[] = $item;
        return $this;
    }
    /**
     * Get Role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->Role;
    }
    /**
     * Set Role value
     * @param string $role
     * @return \Sabre\TokenCreate\Structs\From
     */
    public function setRole($role = null)
    {
        $this->Role = $role;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TokenCreate\Structs\From
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
