<?php

namespace Sabre\SessionClose\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsernameToken Structs
 * @subpackage Structs
 */
class UsernameToken extends AbstractStructBase
{
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The NewPassword
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $NewPassword;
    /**
     * The Organization
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - minOccurs: 0
     * @var string
     */
    public $Organization;
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - minOccurs: 0
     * @var string
     */
    public $Domain;
    /**
     * Constructor method for UsernameToken
     * @uses UsernameToken::setUsername()
     * @uses UsernameToken::setPassword()
     * @uses UsernameToken::setNewPassword()
     * @uses UsernameToken::setOrganization()
     * @uses UsernameToken::setDomain()
     * @param string $username
     * @param string $password
     * @param string[] $newPassword
     * @param string $organization
     * @param string $domain
     */
    public function __construct($username = null, $password = null, array $newPassword = array(), $organization = null, $domain = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setNewPassword($newPassword)
            ->setOrganization($organization)
            ->setDomain($domain);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \Sabre\SessionClose\Structs\UsernameToken
     */
    public function setUsername($username = null)
    {
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \Sabre\SessionClose\Structs\UsernameToken
     */
    public function setPassword($password = null)
    {
        $this->Password = $password;
        return $this;
    }
    /**
     * Get NewPassword value
     * @return string[]|null
     */
    public function getNewPassword()
    {
        return $this->NewPassword;
    }
    /**
     * Set NewPassword value
     * @throws \InvalidArgumentException
     * @param string[] $newPassword
     * @return \Sabre\SessionClose\Structs\UsernameToken
     */
    public function setNewPassword(array $newPassword = array())
    {
        $this->NewPassword = $newPassword;
        return $this;
    }
    /**
     * Add item to NewPassword value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\SessionClose\Structs\UsernameToken
     */
    public function addToNewPassword($item)
    {
        $this->NewPassword[] = $item;
        return $this;
    }
    /**
     * Get Organization value
     * @return string|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param string $organization
     * @return \Sabre\SessionClose\Structs\UsernameToken
     */
    public function setOrganization($organization = null)
    {
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get Domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param string $domain
     * @return \Sabre\SessionClose\Structs\UsernameToken
     */
    public function setDomain($domain = null)
    {
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\SessionClose\Structs\UsernameToken
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
