<?php

namespace Sabre\SessionClose\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SessionCloseRS Structs
 * @subpackage Structs
 */
class SessionCloseRS extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\SessionClose\Structs\Success
     */
    public $Success;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\SessionClose\Structs\Warnings
     */
    public $Warnings;
    /**
     * The ConversationId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ConversationId;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\SessionClose\Structs\Errors
     */
    public $Errors;
    /**
     * The EchoToken
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY- MM- DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-
     * 20T13:59:38Z).
     * - use: optional
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * - use: optional
     * @var string
     */
    public $Target;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * - use: optional
     * @var string
     */
    public $version;
    /**
     * The SequenceNmbr
     * Meta informations extracted from the WSDL
     * - documentation: Used to identify the sequence number of the transaction as assigned by the sending system; allows for an application to process messages in a certain order or to request a resynchronization of messages in the event that a system has
     * been off-line and needs to retrieve messages that were missed.
     * - use: optional
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The PrimaryLangID
     * Meta informations extracted from the WSDL
     * - documentation: Identifes the primary language preference for the form of travel represented in a collection. The human language is identified by ISO 639 codes.
     * - use: optional
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * Meta informations extracted from the WSDL
     * - documentation: Identifes the primary language preference for the form of travel represented in a collection. The human language is identified by ISO 639 codes.
     * - use: optional
     * @var string
     */
    public $AltLangID;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $status;
    /**
     * Constructor method for SessionCloseRS
     * @uses SessionCloseRS::setSuccess()
     * @uses SessionCloseRS::setWarnings()
     * @uses SessionCloseRS::setConversationId()
     * @uses SessionCloseRS::setErrors()
     * @uses SessionCloseRS::setEchoToken()
     * @uses SessionCloseRS::setTimeStamp()
     * @uses SessionCloseRS::setTarget()
     * @uses SessionCloseRS::setVersion()
     * @uses SessionCloseRS::setSequenceNmbr()
     * @uses SessionCloseRS::setPrimaryLangID()
     * @uses SessionCloseRS::setAltLangID()
     * @uses SessionCloseRS::setStatus()
     * @param \Sabre\SessionClose\Structs\Success $success
     * @param \Sabre\SessionClose\Structs\Warnings $warnings
     * @param string $conversationId
     * @param \Sabre\SessionClose\Structs\Errors $errors
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $version
     * @param int $sequenceNmbr
     * @param string $primaryLangID
     * @param string $altLangID
     * @param string $status
     */
    public function __construct(\Sabre\SessionClose\Structs\Success $success = null, \Sabre\SessionClose\Structs\Warnings $warnings = null, $conversationId = null, \Sabre\SessionClose\Structs\Errors $errors = null, $echoToken = null, $timeStamp = null, $target = 'Production', $version = null, $sequenceNmbr = null, $primaryLangID = null, $altLangID = null, $status = null)
    {
        $this
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setConversationId($conversationId)
            ->setErrors($errors)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setSequenceNmbr($sequenceNmbr)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID)
            ->setStatus($status);
    }
    /**
     * Get Success value
     * @return \Sabre\SessionClose\Structs\Success|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \Sabre\SessionClose\Structs\Success $success
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setSuccess(\Sabre\SessionClose\Structs\Success $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \Sabre\SessionClose\Structs\Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \Sabre\SessionClose\Structs\Warnings $warnings
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setWarnings(\Sabre\SessionClose\Structs\Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get ConversationId value
     * @return string|null
     */
    public function getConversationId()
    {
        return $this->ConversationId;
    }
    /**
     * Set ConversationId value
     * @param string $conversationId
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setConversationId($conversationId = null)
    {
        $this->ConversationId = $conversationId;
        return $this;
    }
    /**
     * Get Errors value
     * @return \Sabre\SessionClose\Structs\Errors|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \Sabre\SessionClose\Structs\Errors $errors
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setErrors(\Sabre\SessionClose\Structs\Errors $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setEchoToken($echoToken = null)
    {
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setTarget($target = 'Production')
    {
        $this->Target = $target;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setAltLangID($altLangID = null)
    {
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\SessionClose\Structs\SessionCloseRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
