<?php

namespace Sabre\SessionCreate\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusResponse Structs
 * @subpackage Structs
 */
class StatusResponse extends AbstractStructBase
{
    /**
     * The messageStatus
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $messageStatus;
    /**
     * The RefToMessageId
     * Meta informations extracted from the WSDL
     * - ref: tns:RefToMessageId
     * - minLength: 1
     * @var string
     */
    public $RefToMessageId;
    /**
     * The Timestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for StatusResponse
     * @uses StatusResponse::setMessageStatus()
     * @uses StatusResponse::setRefToMessageId()
     * @uses StatusResponse::setTimestamp()
     * @uses StatusResponse::setAny()
     * @uses StatusResponse::setId()
     * @uses StatusResponse::setVersion()
     * @param string $messageStatus
     * @param string $refToMessageId
     * @param string $timestamp
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct($messageStatus = null, $refToMessageId = null, $timestamp = null, \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setMessageStatus($messageStatus)
            ->setRefToMessageId($refToMessageId)
            ->setTimestamp($timestamp)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get messageStatus value
     * @return string
     */
    public function getMessageStatus()
    {
        return $this->messageStatus;
    }
    /**
     * Set messageStatus value
     * @uses \Sabre\SessionCreate\Enums\MessageStatus_type::valueIsValid()
     * @uses \Sabre\SessionCreate\Enums\MessageStatus_type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageStatus
     * @return \Sabre\SessionCreate\Structs\StatusResponse
     */
    public function setMessageStatus($messageStatus = null)
    {
        $this->messageStatus = $messageStatus;
        return $this;
    }
    /**
     * Get RefToMessageId value
     * @return string|null
     */
    public function getRefToMessageId()
    {
        return $this->RefToMessageId;
    }
    /**
     * Set RefToMessageId value
     * @param string $refToMessageId
     * @return \Sabre\SessionCreate\Structs\StatusResponse
     */
    public function setRefToMessageId($refToMessageId = null)
    {
        $this->RefToMessageId = $refToMessageId;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \Sabre\SessionCreate\Structs\StatusResponse
     */
    public function setTimestamp($timestamp = null)
    {
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\SessionCreate\Structs\StatusResponse::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\SessionCreate\Structs\StatusResponse
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\SessionCreate\Structs\StatusResponse
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Sabre\SessionCreate\Structs\StatusResponse
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\SessionCreate\Structs\StatusResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
