<?php

namespace Sabre\SessionCreate\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error Structs
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ErrorCode;
    /**
     * The Severity
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Severity;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ErrorMessage;
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - use: required
     * - minLength: 1
     * @var string
     */
    public $errorCode;
    /**
     * The severity
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $severity;
    /**
     * The ErrorInfo
     * @var \Sabre\SessionCreate\Structs\ErrorInfo
     */
    public $ErrorInfo;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \Sabre\SessionCreate\Structs\Description
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - ref: tns:id
     * @var string
     */
    public $id;
    /**
     * The codeContext
     * Meta informations extracted from the WSDL
     * - default: urn:oasis:names:tc:ebxml-msg:service:errors
     * @var string
     */
    public $codeContext;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $location;
    /**
     * Constructor method for Error
     * @uses Error::setErrorCode()
     * @uses Error::setSeverity()
     * @uses Error::setErrorMessage()
     * @uses Error::setErrorCode_1()
     * @uses Error::setSeverity_1()
     * @uses Error::setErrorInfo()
     * @uses Error::setDescription()
     * @uses Error::setAny()
     * @uses Error::setId()
     * @uses Error::setCodeContext()
     * @uses Error::setLocation()
     * @param string $errorCode
     * @param string $severity
     * @param string $errorMessage
     * @param string $errorCode
     * @param string $severity
     * @param \Sabre\SessionCreate\Structs\ErrorInfo $errorInfo
     * @param \Sabre\SessionCreate\Structs\Description $description
     * @param \DOMDocument $any
     * @param string $id
     * @param string $codeContext
     * @param string $location
     */
    public function __construct($errorCode = null, $severity = null, $errorMessage = null, $errorCode = null, $severity = null, \Sabre\SessionCreate\Structs\ErrorInfo $errorInfo = null, \Sabre\SessionCreate\Structs\Description $description = null, \DOMDocument $any = null, $id = null, $codeContext = 'urn:oasis:names:tc:ebxml-msg:service:errors', $location = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setSeverity($severity)
            ->setErrorMessage($errorMessage)
            ->setErrorCode_1($errorCode)
            ->setSeverity_1($severity)
            ->setErrorInfo($errorInfo)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setCodeContext($codeContext)
            ->setLocation($location);
    }
    /**
     * Get ErrorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setErrorCode($errorCode = null)
    {
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get Severity value
     * @return string
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setSeverity($severity = null)
    {
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setErrorMessage($errorMessage = null)
    {
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get errorCode_1 value
     * @return errorCode_1
     */
    public function getErrorCode_1()
    {
        return $this->errorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setErrorCode_1($errorCode = null)
    {
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get severity_1 value
     * @return severity_1
     */
    public function getSeverity_1()
    {
        return $this->severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setSeverity_1($severity = null)
    {
        $this->severity = $severity;
        return $this;
    }
    /**
     * Get ErrorInfo value
     * @return \Sabre\SessionCreate\Structs\ErrorInfo|null
     */
    public function getErrorInfo()
    {
        return $this->ErrorInfo;
    }
    /**
     * Set ErrorInfo value
     * @param \Sabre\SessionCreate\Structs\ErrorInfo $errorInfo
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setErrorInfo(\Sabre\SessionCreate\Structs\ErrorInfo $errorInfo = null)
    {
        $this->ErrorInfo = $errorInfo;
        return $this;
    }
    /**
     * Get Description value
     * @return \Sabre\SessionCreate\Structs\Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Sabre\SessionCreate\Structs\Description $description
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setDescription(\Sabre\SessionCreate\Structs\Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\SessionCreate\Structs\Error::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get codeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->codeContext;
    }
    /**
     * Set codeContext value
     * @param string $codeContext
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setCodeContext($codeContext = 'urn:oasis:names:tc:ebxml-msg:service:errors')
    {
        $this->codeContext = $codeContext;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public function setLocation($location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\SessionCreate\Structs\Error
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
