<?php

namespace Sabre\SessionCreate\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DSAKeyValueType Structs
 * @subpackage Structs
 */
class DSAKeyValueType extends AbstractStructBase
{
    /**
     * The P
     * @var string
     */
    public $P;
    /**
     * The Q
     * @var string
     */
    public $Q;
    /**
     * The G
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $G;
    /**
     * The Y
     * @var string
     */
    public $Y;
    /**
     * The J
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $J;
    /**
     * The Seed
     * @var string
     */
    public $Seed;
    /**
     * The PgenCounter
     * @var string
     */
    public $PgenCounter;
    /**
     * Constructor method for DSAKeyValueType
     * @uses DSAKeyValueType::setP()
     * @uses DSAKeyValueType::setQ()
     * @uses DSAKeyValueType::setG()
     * @uses DSAKeyValueType::setY()
     * @uses DSAKeyValueType::setJ()
     * @uses DSAKeyValueType::setSeed()
     * @uses DSAKeyValueType::setPgenCounter()
     * @param string $p
     * @param string $q
     * @param string $g
     * @param string $y
     * @param string $j
     * @param string $seed
     * @param string $pgenCounter
     */
    public function __construct($p = null, $q = null, $g = null, $y = null, $j = null, $seed = null, $pgenCounter = null)
    {
        $this
            ->setP($p)
            ->setQ($q)
            ->setG($g)
            ->setY($y)
            ->setJ($j)
            ->setSeed($seed)
            ->setPgenCounter($pgenCounter);
    }
    /**
     * Get P value
     * @return string|null
     */
    public function getP()
    {
        return $this->P;
    }
    /**
     * Set P value
     * @param string $p
     * @return \Sabre\SessionCreate\Structs\DSAKeyValueType
     */
    public function setP($p = null)
    {
        $this->P = $p;
        return $this;
    }
    /**
     * Get Q value
     * @return string|null
     */
    public function getQ()
    {
        return $this->Q;
    }
    /**
     * Set Q value
     * @param string $q
     * @return \Sabre\SessionCreate\Structs\DSAKeyValueType
     */
    public function setQ($q = null)
    {
        $this->Q = $q;
        return $this;
    }
    /**
     * Get G value
     * @return string|null
     */
    public function getG()
    {
        return $this->G;
    }
    /**
     * Set G value
     * @param string $g
     * @return \Sabre\SessionCreate\Structs\DSAKeyValueType
     */
    public function setG($g = null)
    {
        $this->G = $g;
        return $this;
    }
    /**
     * Get Y value
     * @return string|null
     */
    public function getY()
    {
        return $this->Y;
    }
    /**
     * Set Y value
     * @param string $y
     * @return \Sabre\SessionCreate\Structs\DSAKeyValueType
     */
    public function setY($y = null)
    {
        $this->Y = $y;
        return $this;
    }
    /**
     * Get J value
     * @return string|null
     */
    public function getJ()
    {
        return $this->J;
    }
    /**
     * Set J value
     * @param string $j
     * @return \Sabre\SessionCreate\Structs\DSAKeyValueType
     */
    public function setJ($j = null)
    {
        $this->J = $j;
        return $this;
    }
    /**
     * Get Seed value
     * @return string|null
     */
    public function getSeed()
    {
        return $this->Seed;
    }
    /**
     * Set Seed value
     * @param string $seed
     * @return \Sabre\SessionCreate\Structs\DSAKeyValueType
     */
    public function setSeed($seed = null)
    {
        $this->Seed = $seed;
        return $this;
    }
    /**
     * Get PgenCounter value
     * @return string|null
     */
    public function getPgenCounter()
    {
        return $this->PgenCounter;
    }
    /**
     * Set PgenCounter value
     * @param string $pgenCounter
     * @return \Sabre\SessionCreate\Structs\DSAKeyValueType
     */
    public function setPgenCounter($pgenCounter = null)
    {
        $this->PgenCounter = $pgenCounter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\SessionCreate\Structs\DSAKeyValueType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
