<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellerOrder StructType
 * @subpackage Structs
 */
class SellerOrder extends AbstractStructBase
{
    /**
     * The AvinoSellerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AvinoSellerId;
    /**
     * The SellerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SellerName;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentMethod;
    /**
     * The TotalGrossAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalGrossAmount;
    /**
     * The TotalShippingCosts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalShippingCosts;
    /**
     * The OrderItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OrderItem[]
     */
    public $OrderItem;
    /**
     * Constructor method for SellerOrder
     * @uses SellerOrder::setAvinoSellerId()
     * @uses SellerOrder::setSellerName()
     * @uses SellerOrder::setPaymentMethod()
     * @uses SellerOrder::setTotalGrossAmount()
     * @uses SellerOrder::setTotalShippingCosts()
     * @uses SellerOrder::setOrderItem()
     * @param int $avinoSellerId
     * @param string $sellerName
     * @param string $paymentMethod
     * @param float $totalGrossAmount
     * @param float $totalShippingCosts
     * @param \StructType\OrderItem[] $orderItem
     */
    public function __construct($avinoSellerId = null, $sellerName = null, $paymentMethod = null, $totalGrossAmount = null, $totalShippingCosts = null, array $orderItem = array())
    {
        $this
            ->setAvinoSellerId($avinoSellerId)
            ->setSellerName($sellerName)
            ->setPaymentMethod($paymentMethod)
            ->setTotalGrossAmount($totalGrossAmount)
            ->setTotalShippingCosts($totalShippingCosts)
            ->setOrderItem($orderItem);
    }
    /**
     * Get AvinoSellerId value
     * @return int
     */
    public function getAvinoSellerId()
    {
        return $this->AvinoSellerId;
    }
    /**
     * Set AvinoSellerId value
     * @param int $avinoSellerId
     * @return \StructType\SellerOrder
     */
    public function setAvinoSellerId($avinoSellerId = null)
    {
        // validation for constraint: int
        if (!is_null($avinoSellerId) && !is_numeric($avinoSellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($avinoSellerId)), __LINE__);
        }
        $this->AvinoSellerId = $avinoSellerId;
        return $this;
    }
    /**
     * Get SellerName value
     * @return string
     */
    public function getSellerName()
    {
        return $this->SellerName;
    }
    /**
     * Set SellerName value
     * @param string $sellerName
     * @return \StructType\SellerOrder
     */
    public function setSellerName($sellerName = null)
    {
        // validation for constraint: string
        if (!is_null($sellerName) && !is_string($sellerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sellerName)), __LINE__);
        }
        $this->SellerName = $sellerName;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @uses \EnumType\PaymentMethod::valueIsValid()
     * @uses \EnumType\PaymentMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethod
     * @return \StructType\SellerOrder
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentMethod::valueIsValid($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentMethod, implode(', ', \EnumType\PaymentMethod::getValidValues())), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get TotalGrossAmount value
     * @return float
     */
    public function getTotalGrossAmount()
    {
        return $this->TotalGrossAmount;
    }
    /**
     * Set TotalGrossAmount value
     * @param float $totalGrossAmount
     * @return \StructType\SellerOrder
     */
    public function setTotalGrossAmount($totalGrossAmount = null)
    {
        $this->TotalGrossAmount = $totalGrossAmount;
        return $this;
    }
    /**
     * Get TotalShippingCosts value
     * @return float
     */
    public function getTotalShippingCosts()
    {
        return $this->TotalShippingCosts;
    }
    /**
     * Set TotalShippingCosts value
     * @param float $totalShippingCosts
     * @return \StructType\SellerOrder
     */
    public function setTotalShippingCosts($totalShippingCosts = null)
    {
        $this->TotalShippingCosts = $totalShippingCosts;
        return $this;
    }
    /**
     * Get OrderItem value
     * @return \StructType\OrderItem[]
     */
    public function getOrderItem()
    {
        return $this->OrderItem;
    }
    /**
     * Set OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItem[] $orderItem
     * @return \StructType\SellerOrder
     */
    public function setOrderItem(array $orderItem = array())
    {
        foreach ($orderItem as $sellerOrderOrderItemItem) {
            // validation for constraint: itemType
            if (!$sellerOrderOrderItemItem instanceof \StructType\OrderItem) {
                throw new \InvalidArgumentException(sprintf('The OrderItem property can only contain items of \StructType\OrderItem, "%s" given', is_object($sellerOrderOrderItemItem) ? get_class($sellerOrderOrderItemItem) : gettype($sellerOrderOrderItemItem)), __LINE__);
            }
        }
        $this->OrderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItem $item
     * @return \StructType\SellerOrder
     */
    public function addToOrderItem(\StructType\OrderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItem) {
            throw new \InvalidArgumentException(sprintf('The OrderItem property can only contain items of \StructType\OrderItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SellerOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
