<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderResponse StructType
 * @subpackage Structs
 */
class OrderResponse extends AbstractStructBase
{
    /**
     * The OrderNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The AvinoOrderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvinoOrderId;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for OrderResponse
     * @uses OrderResponse::setOrderNumber()
     * @uses OrderResponse::setStatus()
     * @uses OrderResponse::setAvinoOrderId()
     * @uses OrderResponse::setErrorMessage()
     * @param string $orderNumber
     * @param string $status
     * @param string $avinoOrderId
     * @param string $errorMessage
     */
    public function __construct($orderNumber = null, $status = null, $avinoOrderId = null, $errorMessage = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setStatus($status)
            ->setAvinoOrderId($avinoOrderId)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get OrderNumber value
     * @return string
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\OrderResponse
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\Status::valueIsValid()
     * @uses \EnumType\Status::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\OrderResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Status::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\Status::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get AvinoOrderId value
     * @return string|null
     */
    public function getAvinoOrderId()
    {
        return $this->AvinoOrderId;
    }
    /**
     * Set AvinoOrderId value
     * @param string $avinoOrderId
     * @return \StructType\OrderResponse
     */
    public function setAvinoOrderId($avinoOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($avinoOrderId) && !is_string($avinoOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($avinoOrderId)), __LINE__);
        }
        $this->AvinoOrderId = $avinoOrderId;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\OrderResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
